/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mongodb.DBCollection;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alerts.Alert;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackError;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackSuccess;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class AlarmCallbackHistoryServiceImpl
implements AlarmCallbackHistoryService {
    private final JacksonDBCollection<AlarmCallbackHistoryImpl, String> coll;

    @Inject
    public AlarmCallbackHistoryServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider) {
        String collectionName = AlarmCallbackHistoryImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, AlarmCallbackHistoryImpl.class, String.class, (ObjectMapper)mapperProvider.get());
    }

    @Override
    public List<AlarmCallbackHistory> getForAlertId(String alertId) {
        return this.toAbstractListType(this.coll.find(DBQuery.is((String)"alert_id", (Object)alertId)).toArray());
    }

    @Override
    public AlarmCallbackHistory success(AlarmCallbackConfiguration alarmCallbackConfiguration, Alert alert, AlertCondition alertCondition) {
        return AlarmCallbackHistoryImpl.create(new ObjectId().toHexString(), alarmCallbackConfiguration, alert, alertCondition, AlarmCallbackSuccess.create());
    }

    @Override
    public AlarmCallbackHistory error(AlarmCallbackConfiguration alarmCallbackConfiguration, Alert alert, AlertCondition alertCondition, String error) {
        return AlarmCallbackHistoryImpl.create(new ObjectId().toHexString(), alarmCallbackConfiguration, alert, alertCondition, AlarmCallbackError.create(error));
    }

    @Override
    public AlarmCallbackHistory save(AlarmCallbackHistory alarmCallbackHistory) {
        AlarmCallbackHistoryImpl historyImpl = this.implOrFail(alarmCallbackHistory);
        WriteResult writeResult = this.coll.save((Object)historyImpl);
        return (AlarmCallbackHistory)writeResult.getSavedObject();
    }

    private List<AlarmCallbackHistory> toAbstractListType(List<AlarmCallbackHistoryImpl> histories) {
        ArrayList result = Lists.newArrayListWithCapacity((int)histories.size());
        result.addAll(histories);
        return result;
    }

    private AlarmCallbackHistoryImpl implOrFail(AlarmCallbackHistory history) {
        if (history instanceof AlarmCallbackHistoryImpl) {
            AlarmCallbackHistoryImpl historyImpl = (AlarmCallbackHistoryImpl)history;
            return historyImpl;
        }
        throw new IllegalArgumentException("Supplied output must be of implementation type AlarmCallbackHistoryImpl, not " + history.getClass());
    }
}

