/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.commands.journal;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.graylog2.commands.journal.AbstractJournalCommand;

@Command(name="truncate", description="Truncates the journal to a given offset")
public class JournalTruncate
extends AbstractJournalCommand {
    @Option(name={"-o", "--offset"}, description="Truncate journal up to this offset, no remaining offset will be larger than the given offset.", required=true)
    private long offset = Long.MIN_VALUE;

    public JournalTruncate() {
        super("truncate-journal");
    }

    @Override
    protected void runCommand() {
        try {
            long logEndOffset = this.journal.getLogEndOffset();
            if (this.offset > logEndOffset) {
                System.err.println("Truncating journal to " + this.offset + " has no effect as the largest offset in the log is " + (logEndOffset - 1L) + ".");
            } else {
                this.journal.truncateTo(this.offset);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Illegal offset value " + this.offset);
        }
    }
}

