/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs.gelf;

import org.graylog2.inputs.codecs.gelf.GELFMessage;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;

public final class GELFMessageChunk {
    public static final int HEADER_PART_SEQNUM_START = 10;
    public static final int HEADER_PART_SEQNUM_LENGTH = 1;
    public static final int HEADER_PART_SEQCNT_START = 11;
    public static final int HEADER_PART_SEQCNT_LENGTH = 1;
    public static final int HEADER_PART_HASH_START = 2;
    public static final int HEADER_PART_HASH_LENGTH = 8;
    public static final int HEADER_TOTAL_LENGTH = 12;
    private String id;
    private byte[] data = new byte[1];
    private int sequenceNumber = -1;
    private int sequenceCount = -1;
    private long arrival = -1L;
    private final byte[] payload;
    private final MessageInput sourceInput;

    public GELFMessageChunk(byte[] payload, MessageInput sourceInput) {
        if (payload.length < 12) {
            throw new IllegalArgumentException("This GELF message chunk is too short. Cannot even contain the required header.");
        }
        this.payload = payload;
        this.sourceInput = sourceInput;
        this.read();
    }

    public GELFMessageChunk(GELFMessage msg, MessageInput sourceInput) {
        this(msg.getPayload(), sourceInput);
    }

    public long getArrival() {
        return this.arrival;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MessageInput getSourceInput() {
        return this.sourceInput;
    }

    private void read() {
        this.extractId();
        this.extractSequenceCount();
        this.extractSequenceNumber();
        this.extractData();
        this.arrival = Tools.nowUTC().getMillis();
    }

    private String extractId() {
        if (this.id == null) {
            String tmp = "";
            for (int i = 0; i < 8; ++i) {
                tmp = tmp.concat(Integer.toString((this.payload[i + 2] & 0xFF) + 256, 16).substring(1));
            }
            this.id = tmp;
        }
        return this.id;
    }

    private void extractSequenceNumber() {
        if (this.sequenceNumber == -1) {
            int seqNum = this.sliceInteger(10, 1);
            if (seqNum >= 0) {
                this.sequenceNumber = seqNum;
            } else {
                throw new IllegalStateException("Could not extract sequence number");
            }
        }
    }

    private void extractSequenceCount() {
        if (this.sequenceCount == -1) {
            int seqCnt = this.sliceInteger(11, 1);
            if (seqCnt >= 0) {
                this.sequenceCount = seqCnt;
            } else {
                throw new IllegalStateException("Could not extract sequence count");
            }
        }
    }

    private void extractData() {
        this.data = this.slice(12);
    }

    private int sliceInteger(int start, int length) {
        String tmp = "";
        for (int i = 0; i < length; ++i) {
            tmp = tmp.concat(Integer.toString(this.payload[i + start]));
        }
        return Integer.parseInt(tmp);
    }

    private byte[] slice(int cutOffAt) {
        byte[] tmp = new byte[this.payload.length - cutOffAt];
        int j = 0;
        for (int i = cutOffAt; i < this.payload.length; ++i) {
            tmp[j] = this.payload[i];
            ++j;
        }
        return tmp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID: ");
        sb.append(this.id);
        sb.append("\tSequence: ");
        sb.append(this.sequenceNumber + 1);
        sb.append("/");
        sb.append(this.sequenceCount);
        sb.append("\tArrival: ");
        sb.append(this.arrival);
        sb.append("\tData size: ");
        sb.append(this.payload.length);
        return sb.toString();
    }
}

