/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.random.generators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;

public class FakeHttpRawMessageGenerator {
    private static final Random RANDOM = new Random();
    private static final int MAX_WEIGHT = 50;
    private static final List<Resource> GET_RESOURCES = ImmutableList.of((Object)new Resource("/login", "LoginController", "login", 10), (Object)new Resource("/users", "UsersController", "index", 2), (Object)new Resource("/posts", "PostsController", "index", 40), (Object)new Resource("/posts/45326", "PostsController", "show", 12), (Object)new Resource("/posts/45326/edit", "PostsController", "edit", 1));
    private static final Map<String, Resource> RESOURCE_MAP = Maps.uniqueIndex(GET_RESOURCES, Resource::getResource);
    private static final List<UserId> USER_IDS = ImmutableList.of((Object)new UserId(9001, 10), (Object)new UserId(54351, 1), (Object)new UserId(74422, 5), (Object)new UserId(6476752, 12), (Object)new UserId(6469981, 40));
    private final String source;

    public FakeHttpRawMessageGenerator(String source) {
        this.source = Objects.requireNonNull(source);
    }

    public static int rateDeviation(int val, int maxDeviation, Random rand) {
        int deviationPercent = rand.nextInt(maxDeviation);
        double x = (double)val / 100.0 * (double)deviationPercent;
        double result = rand.nextBoolean() ? (double)val - x : (double)val + x;
        if (result < 0.0) {
            return 1;
        }
        return Math.round((int)result);
    }

    public GeneratorState generateState() {
        GeneratorState generatorState = new GeneratorState();
        int methodProb = RANDOM.nextInt(100);
        int successProb = RANDOM.nextInt(100);
        generatorState.source = this.source;
        generatorState.isSuccessful = successProb < 98;
        generatorState.isTimeout = RANDOM.nextInt(5) == 1;
        generatorState.isSlowRequest = RANDOM.nextInt(500) == 1;
        generatorState.userId = ((UserId)this.getWeighted(USER_IDS)).getId();
        generatorState.resource = ((Resource)this.getWeighted(GET_RESOURCES)).getResource();
        generatorState.method = methodProb <= 85 ? GeneratorState.Method.GET : (methodProb > 85 && methodProb <= 90 ? GeneratorState.Method.POST : (methodProb > 90 && methodProb <= 95 ? GeneratorState.Method.DELETE : GeneratorState.Method.PUT));
        return generatorState;
    }

    public static Message generateMessage(GeneratorState state) {
        Message msg = null;
        switch (state.method) {
            case GET: {
                msg = FakeHttpRawMessageGenerator.simulateGET(state, RANDOM);
                break;
            }
            case POST: {
                msg = FakeHttpRawMessageGenerator.simulatePOST(state, RANDOM);
                break;
            }
            case DELETE: {
                msg = FakeHttpRawMessageGenerator.simulateDELETE(state, RANDOM);
                break;
            }
            case PUT: {
                msg = FakeHttpRawMessageGenerator.simulatePUT(state, RANDOM);
            }
        }
        return msg;
    }

    private static String shortMessage(DateTime ingestTime, GeneratorState.Method method, String resource, int code, int tookMs) {
        return ingestTime + " " + (Object)((Object)method) + " " + resource + " [" + code + "]" + " " + tookMs + "ms";
    }

    private Weighted getWeighted(List<? extends Weighted> list) {
        int x;
        Weighted obj;
        do {
            x = RANDOM.nextInt(50);
        } while ((obj = list.get(RANDOM.nextInt(list.size()))).getWeight() < x);
        return obj;
    }

    private static Map<String, Object> ingestTimeFields(DateTime ingestTime) {
        return ImmutableMap.builder().put((Object)"ingest_time", (Object)ingestTime.toString()).put((Object)"ingest_time_epoch", (Object)ingestTime.getMillis()).put((Object)"ingest_time_second", (Object)ingestTime.getSecondOfMinute()).put((Object)"ingest_time_minute", (Object)ingestTime.getMinuteOfHour()).put((Object)"ingest_time_hour", (Object)ingestTime.getHourOfDay()).put((Object)"ingest_time_day", (Object)ingestTime.getDayOfMonth()).put((Object)"ingest_time_month", (Object)ingestTime.getMonthOfYear()).put((Object)"ingest_time_year", (Object)ingestTime.getYear()).build();
    }

    private static Map<String, Object> resourceFields(Resource resource) {
        return ImmutableMap.builder().put((Object)"resource", (Object)resource.getResource()).put((Object)"controller", (Object)resource.getController()).put((Object)"action", (Object)resource.getAction()).build();
    }

    private static Message createMessage(GeneratorState state, int httpCode, Resource resource, int tookMs, DateTime ingestTime) {
        Message msg = new Message(FakeHttpRawMessageGenerator.shortMessage(ingestTime, state.method, state.resource, httpCode, tookMs), state.source, Tools.nowUTC());
        msg.addFields(FakeHttpRawMessageGenerator.ingestTimeFields(ingestTime));
        msg.addFields(FakeHttpRawMessageGenerator.resourceFields(resource));
        msg.addField("ticks", System.nanoTime());
        msg.addField("http_method", state.method.name());
        msg.addField("http_response_code", httpCode);
        msg.addField("user_id", state.userId);
        msg.addField("took_ms", tookMs);
        return msg;
    }

    public static Message simulateGET(GeneratorState state, Random rand) {
        int code;
        int msBase = 50;
        int deviation = 30;
        int n = code = state.isSuccessful ? 200 : 500;
        if (!state.isSuccessful && state.isTimeout) {
            msBase = 5000;
            deviation = 10;
            code = 504;
        } else if (rand.nextInt(500) == 1) {
            msBase = 400;
        }
        DateTime ingestTime = Tools.nowUTC();
        Resource resource = RESOURCE_MAP.get(state.resource);
        int tookMs = FakeHttpRawMessageGenerator.rateDeviation(msBase, deviation, rand);
        return FakeHttpRawMessageGenerator.createMessage(state, code, resource, tookMs, ingestTime);
    }

    private static Message simulatePOST(GeneratorState state, Random rand) {
        int code;
        int msBase = 150;
        int deviation = 20;
        int n = code = state.isSuccessful ? 201 : 500;
        if (!state.isSuccessful && state.isTimeout) {
            msBase = 5000;
            deviation = 18;
            code = 504;
        } else if (rand.nextInt(500) == 1) {
            msBase = 400;
        }
        DateTime ingestTime = Tools.nowUTC();
        Resource resource = RESOURCE_MAP.get(state.resource);
        int tookMs = FakeHttpRawMessageGenerator.rateDeviation(msBase, deviation, rand);
        return FakeHttpRawMessageGenerator.createMessage(state, code, resource, tookMs, ingestTime);
    }

    private static Message simulatePUT(GeneratorState state, Random rand) {
        int code;
        int msBase = 100;
        int deviation = 30;
        int n = code = state.isSuccessful ? 200 : 500;
        if (!state.isSuccessful && state.isTimeout) {
            msBase = 5000;
            deviation = 18;
            code = 504;
        } else if (rand.nextInt(500) == 1) {
            msBase = 400;
        }
        DateTime ingestTime = Tools.nowUTC();
        Resource resource = RESOURCE_MAP.get(state.resource);
        int tookMs = FakeHttpRawMessageGenerator.rateDeviation(msBase, deviation, rand);
        return FakeHttpRawMessageGenerator.createMessage(state, code, resource, tookMs, ingestTime);
    }

    private static Message simulateDELETE(GeneratorState state, Random rand) {
        int code;
        int msBase = 75;
        int deviation = 40;
        int n = code = state.isSuccessful ? 204 : 500;
        if (!state.isSuccessful && state.isTimeout) {
            msBase = 5000;
            deviation = 18;
            code = 504;
        } else if (rand.nextInt(500) == 1) {
            msBase = 400;
        }
        DateTime ingestTime = Tools.nowUTC();
        Resource resource = RESOURCE_MAP.get(state.resource);
        int tookMs = FakeHttpRawMessageGenerator.rateDeviation(msBase, deviation, rand);
        return FakeHttpRawMessageGenerator.createMessage(state, code, resource, tookMs, ingestTime);
    }

    public static class GeneratorState {
        public String source;
        public boolean isSuccessful;
        public Method method;
        public boolean isTimeout;
        public boolean isSlowRequest;
        public int userId;
        public String resource;

        public static enum Method {
            GET,
            POST,
            DELETE,
            PUT;

        }
    }

    private static class UserId
    extends Weighted {
        private final int id;

        public UserId(int id, int weight) {
            super(weight);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    private static class Resource
    extends Weighted {
        private final String resource;
        private final String controller;
        private final String action;

        public Resource(String resource, String controller, String action, int weight) {
            super(weight);
            this.resource = resource;
            this.controller = controller;
            this.action = action;
        }

        public String getResource() {
            return this.resource;
        }

        public String getController() {
            return this.controller;
        }

        public String getAction() {
            return this.action;
        }
    }

    private static abstract class Weighted {
        protected final int weight;

        protected Weighted(int weight) {
            if (weight <= 0 || weight > 50) {
                throw new RuntimeException("Invalid resource weight: " + weight);
            }
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

