/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.io.Resources;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version
implements Comparable<Version> {
    private static final Logger LOG;
    public final int major;
    public final int minor;
    public final int patch;
    public final String additional;
    public final String abbrevCommitSha;
    public static final Version CURRENT_CLASSPATH;

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null, null);
    }

    public Version(int major, int minor, int patch, String additional) {
        this(major, minor, patch, additional, null);
    }

    public Version(int major, int minor, int patch, String additional, String abbrevCommitSha) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.additional = additional;
        this.abbrevCommitSha = abbrevCommitSha;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (!Strings.isNullOrEmpty((String)this.additional)) {
            sb.append("-").append(this.additional);
        }
        if (!Strings.isNullOrEmpty((String)this.abbrevCommitSha)) {
            sb.append(" (").append(this.abbrevCommitSha).append(')');
        }
        return sb.toString();
    }

    public boolean greaterMinor(Version other) {
        return other.major < this.major || other.major == this.major && other.minor < this.minor;
    }

    public boolean sameOrHigher(Version other) {
        return this.major > other.major || this.major == other.major && (this.minor > other.minor || this.minor == other.minor && this.patch >= other.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return Objects.equals(this.major, that.major) && Objects.equals(this.minor, that.minor) && Objects.equals(this.patch, that.patch) && Objects.equals(this.additional, that.additional) && Objects.equals(this.abbrevCommitSha, that.abbrevCommitSha);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.additional, this.abbrevCommitSha);
    }

    @Override
    public int compareTo(Version that) {
        Preconditions.checkNotNull((Object)that);
        return ComparisonChain.start().compare(this.major, that.major).compare(this.minor, that.minor).compare(this.patch, that.patch).compareFalseFirst(Strings.isNullOrEmpty((String)this.additional), Strings.isNullOrEmpty((String)that.additional)).compare((Comparable)((Object)Strings.nullToEmpty((String)this.additional)), (Comparable)((Object)Strings.nullToEmpty((String)that.additional))).result();
    }

    static {
        Version tmpVersion;
        LOG = LoggerFactory.getLogger(Version.class);
        try {
            URL resource = Resources.getResource((String)"version.properties");
            String versionPropertiesString = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            Properties versionProperties = new Properties();
            versionProperties.load(new StringReader(versionPropertiesString));
            com.github.zafarkhaja.semver.Version version = com.github.zafarkhaja.semver.Version.valueOf((String)versionProperties.getProperty("project.version", "0.0.0"));
            int major = version.getMajorVersion();
            int minor = version.getMinorVersion();
            int incremental = version.getPatchVersion();
            String qualifier = version.getPreReleaseVersion();
            String commitSha = null;
            try {
                Properties git = new Properties();
                URL gitResource = Resources.getResource((String)"git.properties");
                String gitProperties = Resources.toString((URL)gitResource, (Charset)Charsets.UTF_8);
                git.load(new StringReader(gitProperties));
                commitSha = git.getProperty("git.commit.id");
                if (commitSha != null && commitSha.length() > 7) {
                    commitSha = commitSha.substring(0, 7);
                }
            }
            catch (Exception e) {
                LOG.debug("Git commit details are not available, skipping.", (Throwable)e);
            }
            tmpVersion = new Version(major, minor, incremental, qualifier, commitSha);
        }
        catch (Exception e) {
            tmpVersion = new Version(0, 0, 0, "unknown");
            LOG.error("Unable to read version.properties file, this build has no version number.", (Throwable)e);
        }
        CURRENT_CLASSPATH = tmpVersion;
    }
}

