/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AutoValue_RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

@JsonTypeName(value="relative")
public abstract class RelativeRange
extends TimeRange {
    public static final String RELATIVE = "relative";

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract int range();

    public int getRange() {
        return this.range();
    }

    @Override
    @JsonIgnore
    public DateTime getFrom() {
        if (this.range() > 0) {
            return Tools.nowUTC().minus((ReadablePeriod)Seconds.seconds((int)this.range()));
        }
        return new DateTime(0L, DateTimeZone.UTC);
    }

    @Override
    @JsonIgnore
    public DateTime getTo() {
        return Tools.nowUTC();
    }

    @JsonCreator
    public static RelativeRange create(@JsonProperty(value="type") String type, @JsonProperty(value="range") int range) throws InvalidRangeParametersException {
        return RelativeRange.builder().type(type).checkRange(range).build();
    }

    public static RelativeRange create(int range) throws InvalidRangeParametersException {
        return RelativeRange.create(RELATIVE, range);
    }

    public static Builder builder() {
        return new AutoValue_RelativeRange.Builder();
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.of((Object)"type", (Object)RELATIVE, (Object)"range", (Object)this.getRange());
    }

    public static abstract class Builder {
        public abstract RelativeRange build();

        public abstract Builder type(String var1);

        public abstract Builder range(int var1);

        public Builder checkRange(int range) throws InvalidRangeParametersException {
            if (range < 0) {
                throw new InvalidRangeParametersException();
            }
            return this.range(range);
        }
    }
}

