/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.utilities.date;

import com.google.common.collect.Maps;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;

public class NaturalDateParser {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public Result parse(String string) throws DateNotParsableException {
        Date from = null;
        Date to = null;
        Parser parser = new Parser(UTC);
        List groups = parser.parse(string);
        if (!groups.isEmpty()) {
            List dates = ((DateGroup)groups.get(0)).getDates();
            Collections.sort(dates);
            if (dates.size() >= 1) {
                from = (Date)dates.get(0);
            }
            if (dates.size() >= 2) {
                to = (Date)dates.get(1);
            }
        } else {
            throw new DateNotParsableException();
        }
        return new Result(from, to);
    }

    public static class DateNotParsableException
    extends Exception {
    }

    public static class Result {
        private final DateTime from;
        private final DateTime to;

        public Result(Date from, Date to) {
            this.from = from != null ? new DateTime((Object)from, DateTimeZone.UTC) : Tools.nowUTC();
            this.to = to != null ? new DateTime((Object)to, DateTimeZone.UTC) : Tools.nowUTC();
        }

        public DateTime getFrom() {
            return this.from;
        }

        public DateTime getTo() {
            return this.to;
        }

        public Map<String, String> asMap() {
            HashMap result = Maps.newHashMap();
            result.put("from", this.dateFormat(this.getFrom()));
            result.put("to", this.dateFormat(this.getTo()));
            return result;
        }

        private String dateFormat(DateTime x) {
            return x.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC());
        }
    }
}

