/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.count;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.rest.models.count.responses.MessageCountResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Counts", description="Message counts")
@Path(value="/count")
public class CountResource
extends RestResource {
    private final Counts counts;

    @Inject
    public CountResource(Counts counts) {
        this.counts = counts;
    }

    @GET
    @Path(value="/total")
    @Timed
    @RequiresPermissions(value={"messagecount:read"})
    @ApiOperation(value="Total number of messages in all your indices.")
    @Produces(value={"application/json"})
    public MessageCountResponse total() {
        return MessageCountResponse.create(this.counts.total());
    }
}

