/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.google.common.collect.Sets;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.gettingstarted.GettingStartedState;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.models.system.DisplayGettingStarted;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/GettingStartedGuides", description="Getting Started guide")
@Path(value="/system/gettingstarted")
@Produces(value={"application/json"})
public class GettingStartedResource
extends RestResource {
    private final ClusterConfigService clusterConfigService;

    @Inject
    public GettingStartedResource(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    @GET
    @ApiOperation(value="Check whether to display the Getting started guide for this version")
    public DisplayGettingStarted displayGettingStarted() {
        GettingStartedState gettingStartedState = this.clusterConfigService.get(GettingStartedState.class);
        if (gettingStartedState == null) {
            return DisplayGettingStarted.create(true);
        }
        boolean isDismissed = gettingStartedState.dismissedInVersions().contains(GettingStartedResource.currentMinorVersionString());
        return DisplayGettingStarted.create(!isDismissed);
    }

    @POST
    @Path(value="dismiss")
    @ApiOperation(value="Dismiss auto-showing getting started guide for this version")
    public void dismissGettingStarted() {
        GettingStartedState gettingStartedState = this.clusterConfigService.getOrDefault(GettingStartedState.class, GettingStartedState.create(Sets.newHashSet()));
        gettingStartedState.dismissedInVersions().add(GettingStartedResource.currentMinorVersionString());
        this.clusterConfigService.write(gettingStartedState);
    }

    private static String currentMinorVersionString() {
        return String.format("%d.%d", Version.CURRENT_CLASSPATH.major, Version.CURRENT_CLASSPATH.minor);
    }
}

