/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.IndexFailure;
import org.graylog2.indexer.IndexFailureService;
import org.graylog2.rest.models.system.indexer.responses.FailureCount;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Indexer/Failures", description="Indexer failures")
@Path(value="/system/indexer/failures")
public class FailuresResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(FailuresResource.class);
    private IndexFailureService indexFailureService;

    @Inject
    public FailuresResource(IndexFailureService indexFailureService) {
        this.indexFailureService = indexFailureService;
    }

    @GET
    @Timed
    @ApiOperation(value="Total count of failed index operations since the given date.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid date parameter provided.")})
    @RequiresPermissions(value={"indices:failures"})
    @Produces(value={"application/json"})
    @Path(value="count")
    public FailureCount count(@ApiParam(name="since", value="ISO8601 date", required=true) @QueryParam(value="since") @NotEmpty String since) {
        DateTime sinceDate;
        try {
            sinceDate = DateTime.parse((String)since);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid date parameter provided: [" + since + "]";
            LOG.error(msg, (Throwable)e);
            throw new BadRequestException(msg);
        }
        return FailureCount.create(this.indexFailureService.countSince(sinceDate));
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of failed index operations.")
    @RequiresPermissions(value={"indices:failures"})
    @Produces(value={"application/json"})
    public Map<String, Object> single(@ApiParam(name="limit", value="Limit", required=true) @QueryParam(value="limit") @Min(value=0L) int limit, @ApiParam(name="offset", value="Offset", required=true) @QueryParam(value="offset") @Min(value=0L) int offset) {
        List<IndexFailure> indexFailures = this.indexFailureService.all(limit, offset);
        ArrayList<Map<String, Object>> failures = new ArrayList<Map<String, Object>>(indexFailures.size());
        for (IndexFailure failure : indexFailures) {
            failures.add(failure.asMap());
        }
        return ImmutableMap.of((Object)"failures", failures, (Object)"total", (Object)this.indexFailureService.totalCount());
    }
}

