/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.eventbus.EventBus;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputStatesList;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/InputStates", description="Message input states of this node")
@Path(value="/system/inputstates")
@Produces(value={"application/json"})
public class InputStatesResource
extends RestResource {
    private final InputRegistry inputRegistry;
    private final EventBus serverEventBus;
    private final InputService inputService;

    @Inject
    public InputStatesResource(InputRegistry inputRegistry, EventBus serverEventBus, InputService inputService) {
        this.inputRegistry = inputRegistry;
        this.serverEventBus = serverEventBus;
        this.inputService = inputService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all input states of this node")
    public InputStatesList list() {
        Set<InputStateSummary> result = this.inputRegistry.stream().map(inputState -> this.getInputStateSummary((IOState<MessageInput>)inputState)).collect(Collectors.toSet());
        return InputStatesList.create(result);
    }

    @GET
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Get input state for specified input id on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputStateSummary get(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState == null) {
            throw new javax.ws.rs.NotFoundException("No input state for input id <" + inputId + "> on this node.");
        }
        return this.getInputStateSummary(inputState);
    }

    @PUT
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="(Re-)Start specified input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputCreated start(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws NotFoundException {
        this.inputService.find(inputId);
        InputCreated result = InputCreated.create(inputId);
        this.serverEventBus.post((Object)result);
        return result;
    }

    @DELETE
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Stop specified input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputDeleted stop(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws NotFoundException {
        this.inputService.find(inputId);
        InputDeleted result = InputDeleted.create(inputId);
        this.serverEventBus.post((Object)result);
        return result;
    }

    private InputStateSummary getInputStateSummary(IOState<MessageInput> inputState) {
        MessageInput messageInput = inputState.getStoppable();
        return InputStateSummary.create(messageInput.getId(), inputState.getState().toString(), inputState.getStartedAt(), inputState.getDetailedMessage(), InputSummary.create(messageInput.getTitle(), messageInput.isGlobal(), messageInput.getName(), messageInput.getContentPack(), messageInput.getId(), messageInput.getCreatedAt(), messageInput.getType(), messageInput.getCreatorUserId(), messageInput.getConfiguration().getSource(), messageInput.getStaticFields(), messageInput.getNodeId()));
    }
}

