/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.github.joschi.jadconfig.util.Duration;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import okhttp3.OkHttpClient;

@Singleton
public class OkHttpClientProvider
implements Provider<OkHttpClient> {
    protected final Duration connectTimeout;
    protected final Duration readTimeout;
    protected final Duration writeTimeout;
    protected final URI httpProxyUri;

    @Inject
    public OkHttpClientProvider(@Named(value="http_connect_timeout") Duration connectTimeout, @Named(value="http_read_timeout") Duration readTimeout, @Named(value="http_write_timeout") Duration writeTimeout, @Named(value="http_proxy_uri") @Nullable URI httpProxyUri) {
        this.connectTimeout = Objects.requireNonNull(connectTimeout);
        this.readTimeout = Objects.requireNonNull(readTimeout);
        this.writeTimeout = Objects.requireNonNull(writeTimeout);
        this.httpProxyUri = httpProxyUri;
    }

    public OkHttpClient get() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(this.connectTimeout.getQuantity(), this.connectTimeout.getUnit()).writeTimeout(this.writeTimeout.getQuantity(), this.writeTimeout.getUnit()).readTimeout(this.readTimeout.getQuantity(), this.readTimeout.getUnit());
        if (this.httpProxyUri != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxyUri.getHost(), this.httpProxyUri.getPort()));
            clientBuilder.proxy(proxy);
        }
        return clientBuilder.build();
    }
}

