/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.plugin.Capabilities;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.rest.models.system.plugins.responses.PluginList;
import org.graylog2.rest.models.system.plugins.responses.PluginMetaDataValue;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Plugins", description="Plugin information")
@Path(value="/system/plugins")
@Produces(value={"application/json"})
public class SystemPluginResource
extends RestResource {
    private final Set<PluginMetaData> pluginMetaDataSet;

    @Inject
    public SystemPluginResource(Set<PluginMetaData> pluginMetaDataSet) {
        this.pluginMetaDataSet = pluginMetaDataSet;
    }

    @GET
    @Timed
    @ApiOperation(value="List all installed plugins on this node.")
    public PluginList list() {
        ArrayList pluginMetaDataValues = Lists.newArrayList();
        for (PluginMetaData pluginMetaData : this.pluginMetaDataSet) {
            pluginMetaDataValues.add(PluginMetaDataValue.create(pluginMetaData.getUniqueId(), pluginMetaData.getName(), pluginMetaData.getAuthor(), pluginMetaData.getURL(), pluginMetaData.getVersion().toString(), pluginMetaData.getDescription(), pluginMetaData.getRequiredVersion().toString(), Capabilities.toStringSet(pluginMetaData.getRequiredCapabilities())));
        }
        return PluginList.create(pluginMetaDataValues);
    }
}

