/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.plugin.security.Permission;
import org.graylog2.plugin.security.PluginPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestPermissions
implements PluginPermissions {
    private static final Logger LOG = LoggerFactory.getLogger(RestPermissions.class);
    public static final String USERS_CREATE = "users:create";
    public static final String USERS_EDIT = "users:edit";
    public static final String USERS_LIST = "users:list";
    public static final String USERS_PERMISSIONSEDIT = "users:permissionsedit";
    public static final String USERS_PASSWORDCHANGE = "users:passwordchange";
    public static final String USERS_TOKENCREATE = "users:tokencreate";
    public static final String USERS_TOKENLIST = "users:tokenlist";
    public static final String USERS_TOKENREMOVE = "users:tokenremove";
    public static final String USERS_ROLESEDIT = "users:rolesedit";
    public static final String THROUGHPUT_READ = "throughput:read";
    public static final String MESSAGECOUNT_READ = "messagecount:read";
    public static final String DASHBOARDS_CREATE = "dashboards:create";
    public static final String DASHBOARDS_READ = "dashboards:read";
    public static final String DASHBOARDS_EDIT = "dashboards:edit";
    public static final String MESSAGES_READ = "messages:read";
    public static final String MESSAGES_ANALYZE = "messages:analyze";
    public static final String SEARCHES_ABSOLUTE = "searches:absolute";
    public static final String SEARCHES_KEYWORD = "searches:keyword";
    public static final String SEARCHES_RELATIVE = "searches:relative";
    public static final String SAVEDSEARCHES_CREATE = "savedsearches:create";
    public static final String SAVEDSEARCHES_READ = "savedsearches:read";
    public static final String SAVEDSEARCHES_EDIT = "savedsearches:edit";
    public static final String SOURCES_READ = "sources:read";
    public static final String STREAMS_CREATE = "streams:create";
    public static final String STREAMS_READ = "streams:read";
    public static final String STREAMS_EDIT = "streams:edit";
    public static final String STREAMS_CHANGESTATE = "streams:changestate";
    public static final String STREAM_OUTPUTS_CREATE = "stream_outputs:create";
    public static final String STREAM_OUTPUTS_READ = "stream_outputs:read";
    public static final String STREAM_OUTPUTS_DELETE = "stream_outputs:delete";
    public static final String INDEXERCLUSTER_READ = "indexercluster:read";
    public static final String INDICES_READ = "indices:read";
    public static final String INDICES_CHANGESTATE = "indices:changestate";
    public static final String INDICES_DELETE = "indices:delete";
    public static final String INDICES_FAILURES = "indices:failures";
    public static final String INPUTS_READ = "inputs:read";
    public static final String INPUTS_CREATE = "inputs:create";
    public static final String INPUTS_TERMINATE = "inputs:terminate";
    public static final String INPUTS_EDIT = "inputs:edit";
    public static final String OUTPUTS_READ = "outputs:read";
    public static final String OUTPUTS_CREATE = "outputs:create";
    public static final String OUTPUTS_TERMINATE = "outputs:terminate";
    public static final String OUTPUTS_EDIT = "outputs:edit";
    public static final String SYSTEMJOBS_READ = "systemjobs:read";
    public static final String SYSTEMJOBS_CREATE = "systemjobs:create";
    public static final String LDAP_EDIT = "ldap:edit";
    public static final String LDAPGROUPS_READ = "ldapgroups:read";
    public static final String LDAPGROUPS_EDIT = "ldapgroups:edit";
    public static final String LOGGERS_READ = "loggers:read";
    public static final String LOGGERS_EDIT = "loggers:edit";
    public static final String LOGGERS_READSUBSYSTEM = "loggers:readsubsystem";
    public static final String LOGGERS_EDITSUBSYSTEM = "loggers:editsubsystem";
    public static final String BUFFERS_READ = "buffers:read";
    public static final String DEFLECTOR_READ = "deflector:read";
    public static final String DEFLECTOR_CYCLE = "deflector:cycle";
    public static final String INDEXRANGES_READ = "indexranges:read";
    public static final String INDEXRANGES_REBUILD = "indexranges:rebuild";
    public static final String SYSTEMMESSAGES_READ = "systemmessages:read";
    public static final String METRICS_READALL = "metrics:readall";
    public static final String METRICS_ALLKEYS = "metrics:allkeys";
    public static final String METRICS_READ = "metrics:read";
    public static final String METRICS_READHISTORY = "metrics:readhistory";
    public static final String NOTIFICATIONS_READ = "notifications:read";
    public static final String NOTIFICATIONS_DELETE = "notifications:delete";
    public static final String SYSTEM_READ = "system:read";
    public static final String FIELDNAMES_READ = "fieldnames:read";
    public static final String PROCESSING_CHANGESTATE = "processing:changestate";
    public static final String JVMSTATS_READ = "jvmstats:read";
    public static final String THREADS_DUMP = "threads:dump";
    public static final String NODE_SHUTDOWN = "node:shutdown";
    public static final String LBSTATUS_CHANGE = "lbstatus:change";
    public static final String BLACKLISTENTRY_CREATE = "blacklistentry:create";
    public static final String BLACKLISTENTRY_READ = "blacklistentry:read";
    public static final String BLACKLISTENTRY_EDIT = "blacklistentry:edit";
    public static final String BLACKLISTENTRY_DELETE = "blacklistentry:delete";
    public static final String BUNDLE_CREATE = "bundle:create";
    public static final String BUNDLE_READ = "bundle:read";
    public static final String BUNDLE_UPDATE = "bundle:update";
    public static final String BUNDLE_DELETE = "bundle:delete";
    public static final String BUNDLE_IMPORT = "bundle:import";
    public static final String BUNDLE_EXPORT = "bundle:export";
    public static final String JOURNAL_READ = "journal:read";
    public static final String JOURNAL_EDIT = "journal:edit";
    public static final String ROLES_CREATE = "roles:create";
    public static final String ROLES_READ = "roles:read";
    public static final String ROLES_EDIT = "roles:edit";
    public static final String ROLES_DELETE = "roles:delete";
    public static final String CLUSTER_CONFIG_ENTRY_CREATE = "clusterconfigentry:create";
    public static final String CLUSTER_CONFIG_ENTRY_READ = "clusterconfigentry:read";
    public static final String CLUSTER_CONFIG_ENTRY_EDIT = "clusterconfigentry:edit";
    public static final String CLUSTER_CONFIG_ENTRY_DELETE = "clusterconfigentry:delete";
    protected static final ImmutableSet<Permission> PERMISSIONS = ImmutableSet.builder().add((Object)Permission.create("users:create", "")).add((Object)Permission.create("users:edit", "")).add((Object)Permission.create("users:list", "")).add((Object)Permission.create("users:permissionsedit", "")).add((Object)Permission.create("users:passwordchange", "")).add((Object)Permission.create("users:tokencreate", "")).add((Object)Permission.create("users:tokenlist", "")).add((Object)Permission.create("users:tokenremove", "")).add((Object)Permission.create("users:rolesedit", "")).add((Object)Permission.create("throughput:read", "")).add((Object)Permission.create("messagecount:read", "")).add((Object)Permission.create("dashboards:create", "")).add((Object)Permission.create("dashboards:read", "")).add((Object)Permission.create("dashboards:edit", "")).add((Object)Permission.create("messages:read", "")).add((Object)Permission.create("messages:analyze", "")).add((Object)Permission.create("searches:absolute", "")).add((Object)Permission.create("searches:keyword", "")).add((Object)Permission.create("searches:relative", "")).add((Object)Permission.create("savedsearches:create", "")).add((Object)Permission.create("savedsearches:read", "")).add((Object)Permission.create("savedsearches:edit", "")).add((Object)Permission.create("sources:read", "")).add((Object)Permission.create("streams:create", "")).add((Object)Permission.create("streams:read", "")).add((Object)Permission.create("streams:edit", "")).add((Object)Permission.create("streams:changestate", "")).add((Object)Permission.create("stream_outputs:create", "")).add((Object)Permission.create("stream_outputs:read", "")).add((Object)Permission.create("stream_outputs:delete", "")).add((Object)Permission.create("indexercluster:read", "")).add((Object)Permission.create("indices:read", "")).add((Object)Permission.create("indices:changestate", "")).add((Object)Permission.create("indices:delete", "")).add((Object)Permission.create("indices:failures", "")).add((Object)Permission.create("inputs:read", "")).add((Object)Permission.create("inputs:create", "")).add((Object)Permission.create("inputs:terminate", "")).add((Object)Permission.create("inputs:edit", "")).add((Object)Permission.create("outputs:read", "")).add((Object)Permission.create("outputs:create", "")).add((Object)Permission.create("outputs:terminate", "")).add((Object)Permission.create("outputs:edit", "")).add((Object)Permission.create("systemjobs:read", "")).add((Object)Permission.create("systemjobs:create", "")).add((Object)Permission.create("ldap:edit", "")).add((Object)Permission.create("ldapgroups:read", "")).add((Object)Permission.create("ldapgroups:edit", "")).add((Object)Permission.create("loggers:read", "")).add((Object)Permission.create("loggers:edit", "")).add((Object)Permission.create("loggers:readsubsystem", "")).add((Object)Permission.create("loggers:editsubsystem", "")).add((Object)Permission.create("buffers:read", "")).add((Object)Permission.create("deflector:read", "")).add((Object)Permission.create("deflector:cycle", "")).add((Object)Permission.create("indexranges:read", "")).add((Object)Permission.create("indexranges:rebuild", "")).add((Object)Permission.create("systemmessages:read", "")).add((Object)Permission.create("metrics:readall", "")).add((Object)Permission.create("metrics:allkeys", "")).add((Object)Permission.create("metrics:read", "")).add((Object)Permission.create("metrics:readhistory", "")).add((Object)Permission.create("notifications:read", "")).add((Object)Permission.create("notifications:delete", "")).add((Object)Permission.create("system:read", "")).add((Object)Permission.create("fieldnames:read", "")).add((Object)Permission.create("processing:changestate", "")).add((Object)Permission.create("jvmstats:read", "")).add((Object)Permission.create("threads:dump", "")).add((Object)Permission.create("node:shutdown", "")).add((Object)Permission.create("lbstatus:change", "")).add((Object)Permission.create("blacklistentry:create", "")).add((Object)Permission.create("blacklistentry:read", "")).add((Object)Permission.create("blacklistentry:edit", "")).add((Object)Permission.create("blacklistentry:delete", "")).add((Object)Permission.create("bundle:create", "")).add((Object)Permission.create("bundle:read", "")).add((Object)Permission.create("bundle:update", "")).add((Object)Permission.create("bundle:delete", "")).add((Object)Permission.create("bundle:import", "")).add((Object)Permission.create("bundle:export", "")).add((Object)Permission.create("journal:read", "")).add((Object)Permission.create("journal:edit", "")).add((Object)Permission.create("roles:create", "")).add((Object)Permission.create("roles:read", "")).add((Object)Permission.create("roles:edit", "")).add((Object)Permission.create("roles:delete", "")).add((Object)Permission.create("clusterconfigentry:create", "")).add((Object)Permission.create("clusterconfigentry:read", "")).add((Object)Permission.create("clusterconfigentry:edit", "")).add((Object)Permission.create("clusterconfigentry:delete", "")).build();
    protected static final Set<String> READER_BASE_PERMISSION_SELECTION = ImmutableSet.builder().add((Object[])new String[]{"buffers:read", "fieldnames:read", "indexercluster:read", "inputs:read", "journal:read", "jvmstats:read", "messagecount:read", "messages:read", "metrics:read", "system:read", "throughput:read", "savedsearches:create", "savedsearches:edit", "savedsearches:read", "clusterconfigentry:read"}).build();
    protected static final Set<Permission> READER_BASE_PERMISSIONS = PERMISSIONS.stream().filter(permission -> READER_BASE_PERMISSION_SELECTION.contains(permission.permission())).collect(Collectors.toSet());

    @Override
    public Set<Permission> readerBasePermissions() {
        return READER_BASE_PERMISSIONS;
    }

    @Override
    public Set<Permission> permissions() {
        return PERMISSIONS;
    }
}

