/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;
import org.graylog2.shared.security.ContextAwarePermissionAnnotationHandler;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
public class ShiroAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuthorizationFilter.class);
    private final RequiresPermissions annotation;

    public ShiroAuthorizationFilter(RequiresPermissions annotation) {
        this.annotation = annotation;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext instanceof ShiroSecurityContext) {
            ShiroSecurityContext context = (ShiroSecurityContext)securityContext;
            Subject subject = context.getSubject();
            ContextAwarePermissionAnnotationHandler annotationHandler = new ContextAwarePermissionAnnotationHandler(context);
            try {
                LOG.debug("Checking authorization for user {}, needs permissions {}", (Object)subject, (Object)this.annotation.value());
                annotationHandler.assertAuthorized((Annotation)this.annotation);
            }
            catch (AuthorizationException e) {
                LOG.info("User " + subject + "not authorized.", (Throwable)e);
                throw new NotAuthorizedException((Throwable)e, (Object)"Basic realm=\"Graylog Server\"", new Object[0]);
            }
        } else {
            throw new NotAuthorizedException((Object)"Basic realm=\"Graylog Server\"", new Object[0]);
        }
    }
}

