/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.tls;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static List<byte[]> readCertificates(Path path) throws CertificateException {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new CertificateException("Couldn't read certificates from file: " + path, e);
        }
        String content = new String(bytes, StandardCharsets.US_ASCII);
        Matcher m = CERT_PATTERN.matcher(content);
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        int start = 0;
        while (m.find(start)) {
            String s = m.group(1);
            byte[] der = Base64.getDecoder().decode(CharMatcher.BREAKING_WHITESPACE.removeFrom((CharSequence)s));
            certs.add(der);
            start = m.end();
        }
        if (certs.isEmpty()) {
            throw new CertificateException("No certificates found in file: " + path);
        }
        return certs;
    }

    static byte[] readPrivateKey(Path path) throws KeyException {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new KeyException("Couldn't read private key from file: " + path, e);
        }
        String content = new String(bytes, StandardCharsets.US_ASCII);
        Matcher m = KEY_PATTERN.matcher(content);
        if (!m.find()) {
            throw new KeyException("No private key found in file: " + path);
        }
        String s = CharMatcher.BREAKING_WHITESPACE.removeFrom((CharSequence)m.group(1));
        byte[] base64 = s.getBytes(StandardCharsets.US_ASCII);
        return Base64.getDecoder().decode(base64);
    }

    private PemReader() {
    }
}

