/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.jobs;

import java.util.Locale;
import javax.inject.Inject;
import org.graylog2.indexer.healing.FixDeflectorByDeleteJob;
import org.graylog2.indexer.healing.FixDeflectorByMoveJob;
import org.graylog2.system.jobs.NoSuchJobException;
import org.graylog2.system.jobs.SystemJob;

public class SystemJobFactory {
    private final FixDeflectorByMoveJob.Factory fixDeflectorByMoveJobFactory;
    private final FixDeflectorByDeleteJob.Factory fixDeflectorByDeleteJobFactory;

    @Inject
    public SystemJobFactory(FixDeflectorByMoveJob.Factory fixDeflectorByMoveJobFactory, FixDeflectorByDeleteJob.Factory fixDeflectorByDeleteJobFactory) {
        this.fixDeflectorByMoveJobFactory = fixDeflectorByMoveJobFactory;
        this.fixDeflectorByDeleteJobFactory = fixDeflectorByDeleteJobFactory;
    }

    public SystemJob build(String jobName) throws NoSuchJobException {
        switch (SystemJob.Type.valueOf(jobName.toUpperCase(Locale.ENGLISH))) {
            case FIX_DEFLECTOR_DELETE_INDEX: {
                return this.fixDeflectorByDeleteJobFactory.create();
            }
            case FIX_DEFLECTOR_MOVE_INDEX: {
                return this.fixDeflectorByMoveJobFactory.create();
            }
        }
        throw new NoSuchJobException();
    }
}

