/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.google.common.base.MoreObjects;
import java.io.InputStream;
import java.net.URLConnection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.PluginAssets;

@Path(value="{filename: .*}")
public class WebInterfaceAssetsResource {
    private final IndexHtmlGenerator indexHtmlGenerator;

    @Inject
    public WebInterfaceAssetsResource(IndexHtmlGenerator indexHtmlGenerator) {
        this.indexHtmlGenerator = indexHtmlGenerator;
    }

    @GET
    public Response get(@PathParam(value="filename") String filename) {
        if (filename == null || filename.isEmpty() || filename.equals("/") || filename.equals("index.html")) {
            return this.getDefaultResponse();
        }
        InputStream stream = this.getStreamForFile(filename);
        if (stream == null) {
            return this.getDefaultResponse();
        }
        String contentType = (String)MoreObjects.firstNonNull((Object)URLConnection.guessContentTypeFromName(filename), (Object)"application/octet-stream");
        return Response.ok((Object)stream).header("Content-Type", (Object)contentType).build();
    }

    private InputStream getStreamForFile(String filename) {
        return this.getClass().getResourceAsStream("/" + PluginAssets.pathPrefix + "/" + filename);
    }

    private Response getDefaultResponse() {
        return Response.ok((Object)this.indexHtmlGenerator.get()).header("Content-Type", (Object)"text/html").header("X-UA-Compatible", (Object)"IE=edge").build();
    }
}

