/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.elasticsearch.indices.IndexClosedException;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.esplugin.IndexChangeMonitor;
import org.graylog2.indexer.esplugin.IndicesClosedEvent;
import org.graylog2.indexer.esplugin.IndicesDeletedEvent;
import org.graylog2.indexer.esplugin.IndicesReopenedEvent;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.MongoIndexRange;
import org.graylog2.indexer.searches.TimestampStats;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoIndexRangeService
implements IndexRangeService {
    private static final Logger LOG = LoggerFactory.getLogger(MongoIndexRangeService.class);
    private static final String COLLECTION_NAME = "index_ranges";
    private final Indices indices;
    private final JacksonDBCollection<MongoIndexRange, ObjectId> collection;

    @Inject
    public MongoIndexRangeService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider, Indices indices, EventBus eventBus) {
        this.indices = indices;
        this.collection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), MongoIndexRange.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get());
        IndexChangeMonitor.setEventBus(eventBus);
        eventBus.register((Object)this);
        this.collection.createIndex((DBObject)new BasicDBObject("index_name", (Object)1));
        this.collection.createIndex(BasicDBObjectBuilder.start().add("begin", (Object)1).add("end", (Object)1).get());
    }

    @Override
    public IndexRange get(String index) throws NotFoundException {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"start"), DBQuery.is((String)"index_name", (Object)index)});
        MongoIndexRange indexRange = (MongoIndexRange)this.collection.findOne(query);
        if (indexRange == null) {
            throw new NotFoundException("Index range for index <" + index + "> not found.");
        }
        return indexRange;
    }

    @Override
    public SortedSet<IndexRange> find(DateTime begin, DateTime end) {
        DBCursor indexRanges = this.collection.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"start"), DBQuery.lessThanEquals((String)"begin", (Object)end.getMillis()), DBQuery.greaterThanEquals((String)"end", (Object)begin.getMillis())}));
        return ImmutableSortedSet.copyOf(IndexRange.COMPARATOR, (Iterator)indexRanges);
    }

    @Override
    public SortedSet<IndexRange> findAll() {
        return ImmutableSortedSet.copyOf(IndexRange.COMPARATOR, (Iterator)this.collection.find(DBQuery.notExists((String)"start")));
    }

    @Override
    public IndexRange calculateRange(String index) {
        this.indices.waitForRecovery(index);
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        Stopwatch sw = Stopwatch.createStarted();
        TimestampStats stats = this.indices.timestampStatsOfIndex(index);
        int duration = Ints.saturatedCast((long)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        LOG.info("Calculated range of [{}] in [{}ms].", (Object)index, (Object)duration);
        return MongoIndexRange.create(index, stats.min(), stats.max(), now, duration);
    }

    @Override
    public void save(IndexRange indexRange) {
        this.collection.remove(DBQuery.in((String)"index_name", (Object[])new Object[]{indexRange.indexName()}));
        this.collection.save((Object)MongoIndexRange.create(indexRange));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexDeletion(IndicesDeletedEvent event) {
        for (String index : event.indices()) {
            LOG.debug("Index \"{}\" has been deleted. Removing index range.");
            this.collection.remove(DBQuery.in((String)"index_name", (Object[])new Object[]{index}));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexClosing(IndicesClosedEvent event) {
        for (String index : event.indices()) {
            LOG.debug("Index \"{}\" has been closed. Removing index range.");
            this.collection.remove(DBQuery.in((String)"index_name", (Object[])new Object[]{index}));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexReopening(IndicesReopenedEvent event) {
        for (String index : event.indices()) {
            IndexRange indexRange;
            LOG.debug("Index \"{}\" has been reopened. Calculating index range.", (Object)index);
            this.indices.waitForRecovery(index);
            Retryer retryer = RetryerBuilder.newBuilder().retryIfException(input -> !(input instanceof IndexClosedException)).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterDelay((long)5L, (TimeUnit)TimeUnit.MINUTES)).build();
            try {
                indexRange = (IndexRange)retryer.call(() -> this.calculateRange(index));
            }
            catch (Exception e) {
                if (e.getCause() instanceof IndexClosedException) {
                    LOG.debug("Couldn't calculate index range for closed index \"" + index + "\"", e.getCause());
                    return;
                }
                LOG.error("Couldn't calculate index range for index \"" + index + "\"", e.getCause());
                throw new RuntimeException("Couldn't calculate index range for index \"" + index + "\"", e);
            }
            this.save(indexRange);
        }
    }
}

