/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;

@Codec(name="jsonpath", displayName="JSON Path")
public class JsonPathCodec
extends AbstractCodec {
    public static final String CK_PATH = "path";
    public static final String CK_SOURCE = "source";
    private final JsonPath jsonPath;
    private final Configuration configuration;

    @AssistedInject
    public JsonPathCodec(@Assisted Configuration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.jsonPath = configuration.stringIsSet(CK_PATH) ? JsonPath.compile((String)configuration.getString(CK_PATH), (Predicate[])new Predicate[0]) : null;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        if (this.jsonPath == null) {
            return null;
        }
        String json = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        Map<String, Object> fields = this.read(json);
        Message message = new Message(this.buildShortMessage(fields), this.configuration.getString(CK_SOURCE), rawMessage.getTimestamp());
        message.addFields(fields);
        return message;
    }

    @VisibleForTesting
    protected Map<String, Object> read(String json) {
        Object result = this.jsonPath.read(json);
        HashMap fields = Maps.newHashMap();
        if (result instanceof Integer || result instanceof Double || result instanceof Long) {
            fields.put("result", result);
        } else if (result instanceof List) {
            List list = (List)result;
            if (!list.isEmpty()) {
                fields.put("result", list.get(0).toString());
            }
        } else {
            fields.put("result", result.toString());
        }
        return fields;
    }

    @VisibleForTesting
    protected String buildShortMessage(Map<String, Object> fields) {
        StringBuilder shortMessage = new StringBuilder();
        shortMessage.append("JSON API poll result: ");
        shortMessage.append(this.jsonPath.getPath()).append(" -> ");
        if (fields.toString().length() > 50) {
            shortMessage.append(fields.toString().substring(0, 50)).append("[...]");
        } else {
            shortMessage.append(fields.toString());
        }
        return shortMessage.toString();
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField(new TextField(JsonPathCodec.CK_PATH, "JSON path of data to extract", "$.store.book[1].number_of_orders", "Path to the value you want to extract from the JSON response. Take a look at the documentation for a more detailled explanation.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField(new TextField(JsonPathCodec.CK_SOURCE, "Message source", "yourapi", "What to use as source field of the resulting message.", ConfigurationField.Optional.NOT_OPTIONAL));
            return r;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<JsonPathCodec> {
        @Override
        public JsonPathCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

