/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.google.common.base.Charsets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;

@Codec(name="raw", displayName="Raw String")
public class RawCodec
extends AbstractCodec {
    @AssistedInject
    public RawCodec(@Assisted Configuration configuration) {
        super(configuration);
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage raw) {
        ResolvableInetSocketAddress rawRemoteAddress = raw.getRemoteAddress();
        InetAddress remoteAddress = rawRemoteAddress == null ? null : rawRemoteAddress.getAddress();
        return new Message(new String(raw.getPayload(), Charsets.UTF_8), null, raw.getTimestamp());
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
            if (cr.containsField("port")) {
                cr.getField("port").setDefaultValue(5555);
            }
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<RawCodec> {
        @Override
        public RawCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

