/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.tcp;

import com.google.common.base.Charsets;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class SyslogOctetCountFrameDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int frameSizeValueLength = this.findFrameSizeValueLength(buffer);
        if (frameSizeValueLength <= 0) {
            return null;
        }
        String lengthString = buffer.slice(buffer.readerIndex(), frameSizeValueLength).toString(Charsets.UTF_8);
        int length = Integer.parseInt(lengthString);
        int skipLength = frameSizeValueLength + 1;
        if (buffer.readableBytes() - skipLength < length) {
            return null;
        }
        buffer.skipBytes(skipLength);
        ChannelBuffer frame = this.extractFrame(buffer, buffer.readerIndex(), length);
        buffer.skipBytes(length);
        return frame;
    }

    private int findFrameSizeValueLength(ChannelBuffer buffer) {
        int n = buffer.writerIndex();
        for (int i = buffer.readerIndex(); i < n; ++i) {
            byte b = buffer.getByte(i);
            if (b != 32) continue;
            return i - buffer.readerIndex();
        }
        return -1;
    }
}

