/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.AbstractTcpTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;

public class TcpTransport
extends AbstractTcpTransport {
    public static final String CK_USE_NULL_DELIMITER = "use_null_delimiter";
    private static final String CK_MAX_MESSAGE_SIZE = "max_message_size";
    protected final ChannelBuffer[] delimiter;
    protected final int maxFrameLength;

    @AssistedInject
    public TcpTransport(@Assisted Configuration configuration, @Named(value="bossPool") Executor bossPool, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter, LocalMetricRegistry localRegistry) {
        this(configuration, bossPool, TcpTransport.executorService("worker", "tcp-transport-worker-%d", localRegistry), throughputCounter, connectionCounter, localRegistry);
    }

    protected TcpTransport(Configuration configuration, Executor bossPool, Executor workerPool, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter, LocalMetricRegistry localRegistry) {
        super(configuration, throughputCounter, localRegistry, bossPool, workerPool, connectionCounter);
        boolean nulDelimiter = configuration.getBoolean(CK_USE_NULL_DELIMITER);
        this.delimiter = nulDelimiter ? Delimiters.nulDelimiter() : Delimiters.lineDelimiter();
        this.maxFrameLength = configuration.getInt(CK_MAX_MESSAGE_SIZE, 0x200000);
    }

    private static Executor executorService(String executorName, String threadNameFormat, MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build();
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), metricRegistry, MetricRegistry.name(TcpTransport.class, (String[])new String[]{executorName, "executor-service"}));
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getFinalChannelHandlers(MessageInput input) {
        LinkedHashMap finalChannelHandlers = Maps.newLinkedHashMap();
        finalChannelHandlers.put("framer", new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new DelimiterBasedFrameDecoder(TcpTransport.this.maxFrameLength, TcpTransport.this.delimiter);
            }
        });
        finalChannelHandlers.putAll(super.getFinalChannelHandlers(input));
        return finalChannelHandlers;
    }

    @ConfigClass
    public static class Config
    extends AbstractTcpTransport.Config {
        public static final int DEFAULT_MAX_FRAME_LENGTH = 0x200000;

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest x = super.getRequestedConfiguration();
            x.addField(new BooleanField(TcpTransport.CK_USE_NULL_DELIMITER, "Null frame delimiter?", false, "Use null byte as frame delimiter? Otherwise newline delimiter is used."));
            x.addField(new NumberField(TcpTransport.CK_MAX_MESSAGE_SIZE, "Maximum message size", 0x200000, "The maximum length of a message.", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            return x;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<TcpTransport> {
        @Override
        public TcpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

