/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.google.common.annotations.VisibleForTesting;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfiguration.class);
    protected static final int GRAYLOG_DEFAULT_PORT = 12900;
    protected static final int GRAYLOG_DEFAULT_WEB_PORT = 9000;
    @Parameter(value="shutdown_timeout", validator=PositiveIntegerValidator.class)
    protected int shutdownTimeout = 30000;
    @Parameter(value="rest_transport_uri")
    private URI restTransportUri;
    @Parameter(value="processbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int processBufferProcessors = 5;
    @Parameter(value="processor_wait_strategy", required=true)
    private String processorWaitStrategy = "blocking";
    @Parameter(value="ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int ringSize = 65536;
    @Parameter(value="inputbuffer_ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int inputBufferRingSize = 65536;
    @Parameter(value="inputbuffer_wait_strategy", required=true)
    private String inputBufferWaitStrategy = "blocking";
    @Parameter(value="rest_enable_cors")
    private boolean restEnableCors = true;
    @Parameter(value="rest_enable_gzip")
    private boolean restEnableGzip = false;
    @Parameter(value="rest_max_initial_line_length", required=true, validator=PositiveIntegerValidator.class)
    private int restMaxInitialLineLength = 4096;
    @Parameter(value="rest_max_header_size", required=true, validator=PositiveIntegerValidator.class)
    private int restMaxHeaderSize = 8192;
    @Parameter(value="rest_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int restThreadPoolSize = 16;
    @Parameter(value="rest_enable_tls")
    private boolean restEnableTls = false;
    @Parameter(value="rest_tls_cert_file")
    private Path restTlsCertFile;
    @Parameter(value="rest_tls_key_file")
    private Path restTlsKeyFile;
    @Parameter(value="rest_tls_key_password")
    private String restTlsKeyPassword;
    @Parameter(value="plugin_dir")
    private String pluginDir = "plugin";
    @Parameter(value="async_eventbus_processors")
    private int asyncEventbusProcessors = 2;
    @Parameter(value="udp_recvbuffer_sizes", required=true, validator=PositiveIntegerValidator.class)
    private int udpRecvBufferSizes = 0x100000;
    @Parameter(value="message_journal_enabled")
    private boolean messageJournalEnabled = true;
    @Parameter(value="inputbuffer_processors")
    private int inputbufferProcessors = 2;
    @Parameter(value="message_recordings_enable")
    private boolean messageRecordingsEnable = false;
    @Parameter(value="disable_sigar")
    private boolean disableSigar = false;
    @Parameter(value="http_proxy_uri")
    private URI httpProxyUri;
    @Parameter(value="http_connect_timeout", validator=PositiveDurationValidator.class)
    private Duration httpConnectTimeout = Duration.seconds((long)5L);
    @Parameter(value="http_write_timeout", validator=PositiveDurationValidator.class)
    private Duration httpWriteTimeout = Duration.seconds((long)10L);
    @Parameter(value="http_read_timeout", validator=PositiveDurationValidator.class)
    private Duration httpReadTimeout = Duration.seconds((long)10L);
    @Parameter(value="installation_source", validator=StringNotBlankValidator.class)
    private String installationSource = "unknown";
    @Parameter(value="web_enable")
    private boolean webEnable = true;
    @Parameter(value="web_endpoint_uri")
    private URI webEndpointUri;
    @Parameter(value="web_enable_cors")
    private boolean webEnableCors = false;
    @Parameter(value="web_enable_gzip")
    private boolean webEnableGzip = true;
    @Parameter(value="web_max_initial_line_length", required=true, validator=PositiveIntegerValidator.class)
    private int webMaxInitialLineLength = 4096;
    @Parameter(value="web_max_header_size", required=true, validator=PositiveIntegerValidator.class)
    private int webMaxHeaderSize = 8192;
    @Parameter(value="web_enable_tls")
    private boolean webEnableTls = false;
    @Parameter(value="web_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int webThreadPoolSize = 16;
    @Parameter(value="web_tls_cert_file")
    private Path webTlsCertFile;
    @Parameter(value="web_tls_key_file")
    private Path webTlsKeyFile;
    @Parameter(value="web_tls_key_password")
    private String webTlsKeyPassword;

    public String getRestUriScheme() {
        return this.getUriScheme(this.isRestEnableTls());
    }

    public String getWebUriScheme() {
        return this.getUriScheme(this.isWebEnableTls());
    }

    public String getUriScheme(boolean enableTls) {
        return enableTls ? "https" : "http";
    }

    public URI getRestTransportUri() {
        if (this.restTransportUri == null) {
            LOG.debug("No rest_transport_uri set. Using default [{}].", (Object)this.getDefaultRestTransportUri());
            return this.getDefaultRestTransportUri();
        }
        return Tools.getUriWithPort(this.restTransportUri, 12900);
    }

    public void setRestTransportUri(URI restTransportUri) {
        this.restTransportUri = restTransportUri;
    }

    @VisibleForTesting
    protected URI getDefaultRestTransportUri() {
        URI transportUri;
        URI listenUri = this.getRestListenUri();
        if ("0.0.0.0".equals(listenUri.getHost())) {
            InetAddress guessedAddress;
            try {
                guessedAddress = Tools.guessPrimaryNetworkAddress();
                if (guessedAddress.isLoopbackAddress()) {
                    LOG.debug("Using loopback address {}", (Object)guessedAddress);
                }
            }
            catch (Exception e) {
                LOG.error("Could not guess primary network address for \"rest_transport_uri\". Please configure it in your Graylog configuration.", (Throwable)e);
                throw new RuntimeException("No rest_transport_uri.", e);
            }
            transportUri = Tools.getUriWithPort(URI.create("http://" + guessedAddress.getHostAddress() + ":" + listenUri.getPort()), 12900);
        } else {
            transportUri = listenUri;
        }
        return transportUri;
    }

    public int getProcessBufferProcessors() {
        return this.processBufferProcessors;
    }

    private WaitStrategy getWaitStrategy(String waitStrategyName, String configOptionName) {
        switch (waitStrategyName) {
            case "sleeping": {
                return new SleepingWaitStrategy();
            }
            case "yielding": {
                return new YieldingWaitStrategy();
            }
            case "blocking": {
                return new BlockingWaitStrategy();
            }
            case "busy_spinning": {
                return new BusySpinWaitStrategy();
            }
        }
        LOG.warn("Invalid setting for [{}]: Falling back to default: BlockingWaitStrategy.", (Object)configOptionName);
        return new BlockingWaitStrategy();
    }

    public WaitStrategy getProcessorWaitStrategy() {
        return this.getWaitStrategy(this.processorWaitStrategy, "processbuffer_wait_strategy");
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public int getInputBufferRingSize() {
        return this.inputBufferRingSize;
    }

    public WaitStrategy getInputBufferWaitStrategy() {
        return this.getWaitStrategy(this.inputBufferWaitStrategy, "inputbuffer_wait_strategy");
    }

    public boolean isRestEnableCors() {
        return this.restEnableCors;
    }

    public boolean isRestEnableGzip() {
        return this.restEnableGzip;
    }

    public int getRestMaxInitialLineLength() {
        return this.restMaxInitialLineLength;
    }

    public int getRestMaxHeaderSize() {
        return this.restMaxHeaderSize;
    }

    public int getRestThreadPoolSize() {
        return this.restThreadPoolSize;
    }

    public boolean isRestEnableTls() {
        return this.restEnableTls;
    }

    public Path getRestTlsCertFile() {
        return this.restTlsCertFile;
    }

    public Path getRestTlsKeyFile() {
        return this.restTlsKeyFile;
    }

    public String getRestTlsKeyPassword() {
        return this.restTlsKeyPassword;
    }

    public String getPluginDir() {
        return this.pluginDir;
    }

    public int getAsyncEventbusProcessors() {
        return this.asyncEventbusProcessors;
    }

    public abstract String getNodeIdFile();

    public abstract URI getRestListenUri();

    public abstract URI getWebListenUri();

    public boolean isMessageJournalEnabled() {
        return this.messageJournalEnabled;
    }

    public void setMessageJournalEnabled(boolean messageJournalEnabled) {
        this.messageJournalEnabled = messageJournalEnabled;
    }

    public int getInputbufferProcessors() {
        return this.inputbufferProcessors;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public int getUdpRecvBufferSizes() {
        return this.udpRecvBufferSizes;
    }

    public boolean isMessageRecordingsEnabled() {
        return this.messageRecordingsEnable;
    }

    public boolean isDisableSigar() {
        return this.disableSigar;
    }

    public URI getHttpProxyUri() {
        return this.httpProxyUri;
    }

    public Duration getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public Duration getHttpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    public Duration getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public String getInstallationSource() {
        return this.installationSource;
    }

    public boolean isWebEnable() {
        return this.webEnable;
    }

    public boolean isWebEnableCors() {
        return this.webEnableCors;
    }

    public boolean isWebEnableGzip() {
        return this.webEnableGzip;
    }

    public int getWebMaxInitialLineLength() {
        return this.webMaxInitialLineLength;
    }

    public int getWebMaxHeaderSize() {
        return this.webMaxHeaderSize;
    }

    public boolean isWebEnableTls() {
        return this.webEnableTls;
    }

    public int getWebThreadPoolSize() {
        return this.webThreadPoolSize;
    }

    public Path getWebTlsCertFile() {
        return this.webTlsCertFile;
    }

    public Path getWebTlsKeyFile() {
        return this.webTlsKeyFile;
    }

    public String getWebTlsKeyPassword() {
        return this.webTlsKeyPassword;
    }

    public URI getWebEndpointUri() {
        return this.webEndpointUri == null ? this.getRestTransportUri() : this.webEndpointUri;
    }
}

