/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.codahale.metrics.Meter;
import com.eaio.uuid.UUID;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements Messages {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    public static final String FIELD_ID = "_id";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_FULL_MESSAGE = "full_message";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_STREAMS = "streams";
    private static final Pattern VALID_KEY_CHARS = Pattern.compile("^[\\w\\.\\-@]*$");
    private static final char KEY_REPLACEMENT_CHAR = '_';
    public static final ImmutableSet<String> RESERVED_FIELDS = ImmutableSet.of((Object)"_id", (Object)"_ttl", (Object)"_source", (Object)"_all", (Object)"_index", (Object)"_type", (Object[])new String[]{"_score", "message", "source", "timestamp", "gl2_source_node", "gl2_source_input", "gl2_source_collector", "gl2_source_collector_input", "gl2_remote_ip", "gl2_remote_port", "gl2_remote_hostname", "gl2_source_radio", "gl2_source_radio_input"});
    public static final ImmutableSet<String> RESERVED_SETTABLE_FIELDS = ImmutableSet.of((Object)"message", (Object)"source", (Object)"timestamp", (Object)"gl2_source_node", (Object)"gl2_source_input", (Object)"gl2_source_radio", (Object[])new String[]{"gl2_source_radio_input", "gl2_source_collector", "gl2_source_collector_input", "gl2_remote_ip", "gl2_remote_port", "gl2_remote_hostname"});
    private static final ImmutableSet<String> REQUIRED_FIELDS = ImmutableSet.of((Object)"message", (Object)"_id");
    public static final Function<Message, String> ID_FUNCTION = new MessageIdFunction();
    private final Map<String, Object> fields = Maps.newHashMap();
    private Set<Stream> streams = Sets.newHashSet();
    private String sourceInputId;
    private boolean filterOut = false;
    private long journalOffset = Long.MIN_VALUE;
    private ArrayList<Recording> recordings;

    public Message(String message, String source, DateTime timestamp) {
        this.fields.put(FIELD_ID, new UUID().toString());
        this.fields.put(FIELD_MESSAGE, message);
        this.fields.put(FIELD_SOURCE, source);
        this.fields.put(FIELD_TIMESTAMP, timestamp);
    }

    public Message(Map<String, Object> fields) {
        this((String)fields.get(FIELD_ID), Maps.filterKeys(fields, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)FIELD_ID))));
    }

    private Message(String id, Map<String, Object> newFields) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"message id cannot be null");
        this.fields.put(FIELD_ID, id);
        this.addFields(newFields);
    }

    public boolean isComplete() {
        for (String key : REQUIRED_FIELDS) {
            Object field = this.getField(key);
            if (field != null && (!(field instanceof String) || !((String)field).isEmpty())) continue;
            return false;
        }
        return true;
    }

    public String getValidationErrors() {
        StringBuilder sb = new StringBuilder();
        for (String key : REQUIRED_FIELDS) {
            Object field = this.getField(key);
            if (field == null) {
                sb.append(key).append(" is missing, ");
                continue;
            }
            if (!(field instanceof String) || !((String)field).isEmpty()) continue;
            sb.append(key).append(" is empty, ");
        }
        return sb.toString();
    }

    public String getId() {
        return this.getFieldAs(String.class, FIELD_ID);
    }

    public DateTime getTimestamp() {
        return this.getFieldAs(DateTime.class, FIELD_TIMESTAMP).withZone(DateTimeZone.UTC);
    }

    public Map<String, Object> toElasticSearchObject(@Nonnull Meter invalidTimestampMeter) {
        DateTime dateTime;
        HashMap obj = Maps.newHashMapWithExpectedSize((int)(REQUIRED_FIELDS.size() + this.fields.size()));
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String newKey;
            String key = entry.getKey();
            if (key != null && key.contains(".")) {
                newKey = key.replace('.', '_');
                if (!obj.containsKey(newKey)) {
                    obj.put(newKey, entry.getValue());
                    continue;
                }
                LOG.warn("Keys must not contain a \".\" character! Ignoring field \"{}\"=\"{}\" in message [{}] - Unable to replace \".\" with a \"{}\" because of key conflict: \"{}\"=\"{}\"", new Object[]{key, entry.getValue(), this.getId(), Character.valueOf('_'), newKey, obj.get(newKey)});
                LOG.debug("Full message with \".\" in message key: {}", (Object)this);
                continue;
            }
            if (key != null && obj.containsKey(key)) {
                newKey = key.replace('_', '.');
                LOG.warn("Keys must not contain a \".\" character! Ignoring field \"{}\"=\"{}\" in message [{}] - Unable to replace \".\" with a \"{}\" because of key conflict: \"{}\"=\"{}\"", new Object[]{newKey, this.fields.get(newKey), this.getId(), Character.valueOf('_'), key, entry.getValue()});
                LOG.debug("Full message with \".\" in message key: {}", (Object)this);
            }
            obj.put(key, entry.getValue());
        }
        obj.put(FIELD_MESSAGE, this.getMessage());
        obj.put(FIELD_SOURCE, this.getSource());
        Object timestampValue = this.getField(FIELD_TIMESTAMP);
        if (timestampValue instanceof Date) {
            dateTime = new DateTime(timestampValue);
        } else if (timestampValue instanceof DateTime) {
            dateTime = (DateTime)timestampValue;
        } else if (timestampValue instanceof String) {
            try {
                dateTime = Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime((String)timestampValue);
            }
            catch (IllegalArgumentException e) {
                LOG.trace("Invalid format for field timestamp '{}' in message {}, forcing to current time.", timestampValue, (Object)this.getId());
                invalidTimestampMeter.mark();
                dateTime = Tools.nowUTC();
            }
        } else {
            LOG.trace("Invalid type for field timestamp '{}' in message {}, forcing to current time.", (Object)timestampValue.getClass().getSimpleName(), (Object)this.getId());
            invalidTimestampMeter.mark();
            dateTime = Tools.nowUTC();
        }
        if (dateTime != null) {
            obj.put(FIELD_TIMESTAMP, Tools.buildElasticSearchTimeFormat(dateTime.withZone(DateTimeZone.UTC)));
        }
        if (this.getStreams().isEmpty()) {
            obj.put(FIELD_STREAMS, Collections.emptyList());
        } else {
            ArrayList streamIds = Lists.newArrayListWithCapacity((int)this.streams.size());
            for (Stream stream : this.streams) {
                streamIds.add(stream.getId());
            }
            obj.put(FIELD_STREAMS, streamIds);
        }
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("source: ").append(this.getField(FIELD_SOURCE)).append(" | ");
        String message = this.getField(FIELD_MESSAGE).toString().replaceAll("\\n", "").replaceAll("\\t", "");
        sb.append("message: ");
        if (message.length() > 225) {
            sb.append(message.substring(0, 225)).append(" (...)");
        } else {
            sb.append(message);
        }
        sb.append(" { ");
        HashMap filteredFields = Maps.newHashMap(this.fields);
        filteredFields.remove(FIELD_SOURCE);
        filteredFields.remove(FIELD_MESSAGE);
        Joiner.on((String)" | ").withKeyValueSeparator(": ").appendTo(sb, (Map)filteredFields);
        sb.append(" }");
        return sb.toString();
    }

    public String getMessage() {
        return this.getFieldAs(String.class, FIELD_MESSAGE);
    }

    public String getSource() {
        return this.getFieldAs(String.class, FIELD_SOURCE);
    }

    public void setSource(String source) {
        this.fields.put(FIELD_SOURCE, source);
    }

    public void addField(String key, Object value) {
        if (RESERVED_FIELDS.contains((Object)key) && !RESERVED_SETTABLE_FIELDS.contains((Object)key) || !Message.validKey(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring invalid or reserved key {} for message {}", (Object)key, (Object)this.getId());
            }
            return;
        }
        if (FIELD_TIMESTAMP.equals(key.trim()) && value != null && value instanceof Date) {
            this.fields.put(FIELD_TIMESTAMP, new DateTime(value));
        } else if (value instanceof String) {
            String str = ((String)value).trim();
            if (!str.isEmpty()) {
                this.fields.put(key.trim(), str);
            }
        } else if (value != null) {
            this.fields.put(key.trim(), value);
        }
    }

    public static boolean validKey(String key) {
        return VALID_KEY_CHARS.matcher(key).matches();
    }

    public void addFields(Map<String, Object> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    public void addStringFields(Map<String, String> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, String> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    public void addLongFields(Map<String, Long> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Long> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    public void addDoubleFields(Map<String, Double> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Double> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    public void removeField(String key) {
        if (!RESERVED_FIELDS.contains((Object)key)) {
            this.fields.remove(key);
        }
    }

    public <T> T getFieldAs(Class<T> T, String key) throws ClassCastException {
        return T.cast(this.getField(key));
    }

    public Object getField(String key) {
        return this.fields.get(key);
    }

    public Map<String, Object> getFields() {
        return ImmutableMap.copyOf(this.fields);
    }

    public Iterable<Map.Entry<String, Object>> getFieldsEntries() {
        return Iterables.unmodifiableIterable(this.fields.entrySet());
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean hasField(String field) {
        return this.fields.containsKey(field);
    }

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    @Deprecated
    public void setStreams(List<Stream> streams) {
        this.streams = Sets.newHashSet(streams);
    }

    public Set<Stream> getStreams() {
        return ImmutableSet.copyOf(this.streams);
    }

    public void addStream(Stream stream) {
        this.streams.add(stream);
    }

    public void addStreams(Iterable<Stream> newStreams) {
        Iterables.addAll(this.streams, newStreams);
    }

    public boolean removeStream(Stream stream) {
        return this.streams.remove(stream);
    }

    public List<String> getStreamIds() {
        if (!this.hasField(FIELD_STREAMS)) {
            return Collections.emptyList();
        }
        try {
            return Lists.newArrayList((Iterable)this.getFieldAs(List.class, FIELD_STREAMS));
        }
        catch (ClassCastException e) {
            return Collections.emptyList();
        }
    }

    public void setFilterOut(boolean filterOut) {
        this.filterOut = filterOut;
    }

    public boolean getFilterOut() {
        return this.filterOut;
    }

    public void setSourceInputId(String sourceInputId) {
        this.sourceInputId = sourceInputId;
    }

    public String getSourceInputId() {
        return this.sourceInputId;
    }

    public boolean getIsSourceInetAddress() {
        return this.fields.containsKey("gl2_remote_ip");
    }

    public InetAddress getInetAddress() {
        if (!this.fields.containsKey("gl2_remote_ip")) {
            return null;
        }
        String ipAddr = (String)this.fields.get("gl2_remote_ip");
        try {
            return InetAddresses.forString((String)ipAddr);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public void setJournalOffset(long journalOffset) {
        this.journalOffset = journalOffset;
    }

    public long getJournalOffset() {
        return this.journalOffset;
    }

    public void recordTiming(ServerStatus serverStatus, String name, long elapsedNanos) {
        if (this.shouldNotRecord(serverStatus)) {
            return;
        }
        this.lazyInitRecordings();
        this.recordings.add(Recording.timing(name, elapsedNanos));
    }

    public void recordCounter(ServerStatus serverStatus, String name, int counter) {
        if (this.shouldNotRecord(serverStatus)) {
            return;
        }
        this.lazyInitRecordings();
        this.recordings.add(Recording.counter(name, counter));
    }

    public String recordingsAsString() {
        if (this.hasRecordings()) {
            return Joiner.on((String)", ").join(this.recordings);
        }
        return "";
    }

    public boolean hasRecordings() {
        return this.recordings != null && this.recordings.size() > 0;
    }

    private void lazyInitRecordings() {
        if (this.recordings == null) {
            this.recordings = new ArrayList();
        }
    }

    private boolean shouldNotRecord(ServerStatus serverStatus) {
        return !serverStatus.getDetailedMessageRecordingStrategy().shouldRecord(this);
    }

    @Override
    public Iterator<Message> iterator() {
        if (this.getFilterOut()) {
            return Collections.emptyIterator();
        }
        return Iterators.singletonIterator((Object)this);
    }

    public static class MessageIdFunction
    implements Function<Message, String> {
        public String apply(Message input) {
            return input.getId();
        }
    }

    private static class Counter
    extends Recording {
        private final String name;
        private final int counter;

        public Counter(String name, int counter) {
            this.name = name;
            this.counter = counter;
        }

        public String toString() {
            return this.name + ": " + this.counter;
        }
    }

    private static class Timing
    extends Recording {
        private final String name;
        private final long elapsedNanos;

        public Timing(String name, long elapsedNanos) {
            this.name = name;
            this.elapsedNanos = elapsedNanos;
        }

        public String toString() {
            return this.name + ": " + TimeUnit.NANOSECONDS.toMicros(this.elapsedNanos) + "micros";
        }
    }

    public static abstract class Recording {
        public static Timing timing(String name, long elapsedNanos) {
            return new Timing(name, elapsedNanos);
        }

        public static Counter counter(String name, int counter) {
            return new Counter(name, counter);
        }
    }
}

