/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration.fields;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import org.graylog2.plugin.configuration.fields.AbstractConfigurationField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;

public class TextField
extends AbstractConfigurationField {
    public static final String FIELD_TYPE = "text";
    private String defaultValue;
    private final List<String> attributes;

    public TextField(String name, String humanName, String defaultValue, String description, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, description, isOptional, new Attribute[0]);
    }

    public TextField(String name, String humanName, String defaultValue, String description, Attribute ... attributes) {
        this(name, humanName, defaultValue, description, ConfigurationField.Optional.NOT_OPTIONAL, attributes);
    }

    public TextField(String name, String humanName, String defaultValue, String description, ConfigurationField.Optional isOptional, Attribute ... attrs) {
        super(FIELD_TYPE, name, humanName, description, isOptional);
        this.defaultValue = defaultValue;
        this.attributes = Lists.newArrayList();
        if (attrs != null) {
            for (Attribute attribute : attrs) {
                this.attributes.add(attribute.toString().toLowerCase(Locale.ENGLISH));
            }
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        if (defaultValue instanceof String) {
            this.defaultValue = (String)defaultValue;
        }
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    public static enum Attribute {
        IS_PASSWORD,
        TEXTAREA;

    }
}

