/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.plugin.indexer.searches.timeranges.AutoValue_KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.utilities.date.NaturalDateParser;
import org.joda.time.DateTime;

@JsonTypeName(value="keyword")
public abstract class KeywordRange
extends TimeRange {
    private static final NaturalDateParser DATE_PARSER = new NaturalDateParser();
    public static final String KEYWORD = "keyword";

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract String keyword();

    @JsonIgnore
    public abstract NaturalDateParser.Result parseResult();

    @JsonCreator
    public static KeywordRange create(@JsonProperty(value="type") String type, @JsonProperty(value="keyword") String keyword) throws InvalidRangeParametersException {
        return KeywordRange.builder().type(type).keyword(keyword).build();
    }

    public static KeywordRange create(String keyword) throws InvalidRangeParametersException {
        return KeywordRange.create(KEYWORD, keyword);
    }

    private static Builder builder() {
        return new AutoValue_KeywordRange.Builder();
    }

    public String getKeyword() {
        return this.keyword();
    }

    @Override
    @JsonIgnore
    public DateTime getFrom() {
        return this.parseResult().getFrom();
    }

    @Override
    @JsonIgnore
    public DateTime getTo() {
        return this.parseResult().getTo();
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.builder().put((Object)"type", (Object)KEYWORD).put((Object)KEYWORD, (Object)this.getKeyword()).build();
    }

    public static abstract class Builder {
        public abstract Builder type(String var1);

        public abstract Builder keyword(String var1);

        abstract String keyword();

        public abstract Builder parseResult(NaturalDateParser.Result var1);

        abstract KeywordRange autoBuild();

        public KeywordRange build() throws InvalidRangeParametersException {
            NaturalDateParser.Result parse;
            try {
                parse = DATE_PARSER.parse(this.keyword());
            }
            catch (NaturalDateParser.DateNotParsableException e) {
                throw new InvalidRangeParametersException("Could not parse from natural date: " + this.keyword());
            }
            this.parseResult(parse);
            return this.autoBuild();
        }
    }
}

