/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.dashboards;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetResultCache;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.rest.models.dashboards.requests.AddWidgetRequest;
import org.graylog2.rest.models.dashboards.requests.UpdateWidgetRequest;
import org.graylog2.rest.models.dashboards.responses.WidgetSummary;
import org.graylog2.rest.resources.dashboards.DashboardsResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Dashboards/Widgets", description="Manage widgets of an existing dashboard")
@Path(value="/dashboards/{dashboardId}/widgets")
public class DashboardWidgetsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardWidgetsResource.class);
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final ActivityWriter activityWriter;
    private final WidgetResultCache widgetResultCache;
    private final DashboardService dashboardService;

    @Inject
    public DashboardWidgetsResource(DashboardWidgetCreator dashboardWidgetCreator, ActivityWriter activityWriter, WidgetResultCache widgetResultCache, DashboardService dashboardService) {
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.activityWriter = activityWriter;
        this.widgetResultCache = widgetResultCache;
        this.dashboardService = dashboardService;
    }

    @POST
    @Timed
    @ApiOperation(value="Add a widget to a dashboard")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=400, message="Validation error."), @ApiResponse(code=400, message="No such widget type.")})
    public Response addWidget(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) AddWidgetRequest awr) throws ValidationException, NotFoundException {
        DashboardWidget widget;
        this.checkPermission("dashboards:edit", dashboardId);
        if (awr.config().containsKey("stream_id")) {
            this.checkPermission("streams:read", (String)awr.config().get("stream_id"));
        } else {
            this.checkPermission("searches:absolute");
            this.checkPermission("searches:relative");
            this.checkPermission("searches:keyword");
        }
        try {
            widget = this.dashboardWidgetCreator.fromRequest(awr, this.getCurrentUser().getName());
            Dashboard dashboard = this.dashboardService.load(dashboardId);
            this.dashboardService.addWidget(dashboard, widget);
        }
        catch (DashboardWidget.NoSuchWidgetTypeException e2) {
            LOG.debug("No such widget type.", (Throwable)e2);
            throw new BadRequestException("No such widget type.", (Throwable)e2);
        }
        catch (InvalidRangeParametersException e3) {
            LOG.debug("Invalid timerange parameters provided.", (Throwable)e3);
            throw new BadRequestException("Invalid timerange parameters provided.", (Throwable)e3);
        }
        catch (InvalidWidgetConfigurationException e4) {
            LOG.debug("Invalid widget configuration.", (Throwable)e4);
            throw new BadRequestException("Invalid widget configuration.", (Throwable)e4);
        }
        ImmutableMap result = ImmutableMap.of((Object)"widget_id", (Object)widget.getId());
        URI widgetUri = this.getUriBuilderToSelf().path(DashboardWidgetsResource.class, "getWidget").build(new Object[]{dashboardId, widget.getId()});
        return Response.created((URI)widgetUri).entity((Object)result).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get a widget")
    @Path(value="/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public WidgetSummary getWidget(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException {
        this.checkPermission("dashboards:read", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        return WidgetSummary.create(widget.getId(), widget.getDescription(), widget.getType(), widget.getCacheTime(), widget.getCreatorUserId(), widget.getConfig());
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete a widget")
    @Path(value="/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public void remove(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        this.widgetResultCache.invalidate(widget);
        this.dashboardService.removeWidget(dashboard, widget);
        String msg = "Deleted widget <" + widgetId + "> from dashboard <" + dashboardId + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DashboardsResource.class));
    }

    @GET
    @Timed
    @ApiOperation(value="Get a single widget value.")
    @Path(value="/{widgetId}/value")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=504, message="Computation failed on indexer side.")})
    @Produces(value={"application/json"})
    public Map<String, Object> widgetValue(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException, InvalidWidgetConfigurationException {
        this.checkPermission("dashboards:read", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new javax.ws.rs.NotFoundException();
        }
        return this.widgetResultCache.getComputationResultForDashboardWidget(widget).asMap();
    }

    @PUT
    @Timed
    @ApiOperation(value="Update a widget")
    @Path(value="/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public void updateWidget(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId, @ApiParam(name="JSON body", required=true) @Valid @NotNull AddWidgetRequest awr) throws ValidationException, NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new javax.ws.rs.NotFoundException();
        }
        try {
            DashboardWidget updatedWidget = this.dashboardWidgetCreator.fromRequest(widgetId, awr, widget.getCreatorUserId());
            updatedWidget.setCacheTime(awr.cacheTime());
            this.dashboardService.removeWidget(dashboard, widget);
            this.dashboardService.addWidget(dashboard, updatedWidget);
            this.widgetResultCache.invalidate(widget);
        }
        catch (DashboardWidget.NoSuchWidgetTypeException e2) {
            LOG.error("No such widget type.", (Throwable)e2);
            throw new BadRequestException((Throwable)e2);
        }
        catch (InvalidRangeParametersException e3) {
            LOG.error("Invalid timerange parameters provided.", (Throwable)e3);
            throw new BadRequestException((Throwable)e3);
        }
        catch (InvalidWidgetConfigurationException e4) {
            LOG.error("Invalid widget configuration.", (Throwable)e4);
            throw new BadRequestException((Throwable)e4);
        }
        LOG.info("Updated widget <" + widgetId + "> on dashboard <" + dashboardId + ">. Reason: REST request.");
    }

    @Deprecated
    @PUT
    @Timed
    @ApiOperation(value="Update description of a widget")
    @Path(value="/{widgetId}/description")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public void updateDescription(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId, @ApiParam(name="JSON body", required=true) @Valid UpdateWidgetRequest uwr) throws ValidationException, NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new javax.ws.rs.NotFoundException();
        }
        this.dashboardService.updateWidgetDescription(dashboard, widget, uwr.description());
        LOG.info("Updated description of widget <" + widgetId + "> on dashboard <" + dashboardId + ">. Reason: REST request.");
    }

    @Deprecated
    @PUT
    @Timed
    @ApiOperation(value="Update cache time of a widget")
    @Path(value="/{widgetId}/cachetime")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public void updateCacheTime(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId, @ApiParam(name="JSON body", required=true) @Valid UpdateWidgetRequest uwr) throws ValidationException, NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new javax.ws.rs.NotFoundException();
        }
        this.dashboardService.updateWidgetCacheTime(dashboard, widget, uwr.cacheTime());
        this.widgetResultCache.invalidate(widget);
        LOG.info("Updated cache time of widget <" + widgetId + "> on dashboard <" + dashboardId + "> to " + "[" + uwr.cacheTime() + "]. Reason: REST request.");
    }
}

