/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.roles;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.roles.responses.RoleMembershipResponse;
import org.graylog2.rest.models.roles.responses.RoleResponse;
import org.graylog2.rest.models.roles.responses.RolesResponse;
import org.graylog2.rest.models.users.responses.UserSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.Role;
import org.graylog2.users.RoleImpl;
import org.graylog2.users.RoleService;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="Roles", description="User roles")
public class RolesResource
extends RestResource {
    private static final Logger log = LoggerFactory.getLogger(RolesResource.class);
    private final RoleService roleService;

    @Inject
    public RolesResource(RoleService roleService) {
        this.roleService = roleService;
    }

    @GET
    @RequiresPermissions(value={"roles:read"})
    @ApiOperation(value="List all roles", notes="")
    public RolesResponse listAll() throws NotFoundException {
        Set<Role> roles = this.roleService.loadAll();
        HashSet roleResponses = Sets.newHashSet();
        for (Role role : roles) {
            roleResponses.add(RoleResponse.create(role.getName(), (Optional<String>)Optional.fromNullable((Object)role.getDescription()), role.getPermissions(), role.isReadOnly()));
        }
        return RolesResponse.create(roleResponses);
    }

    @GET
    @Path(value="{rolename}")
    @ApiOperation(value="Retrieve permissions for a single role")
    public RoleResponse read(@ApiParam(name="rolename", required=true) @PathParam(value="rolename") String name) throws NotFoundException {
        this.checkPermission("roles:read", name);
        Role role = this.roleService.load(name);
        return RoleResponse.create(role.getName(), (Optional<String>)Optional.fromNullable((Object)role.getDescription()), role.getPermissions(), role.isReadOnly());
    }

    @POST
    @RequiresPermissions(value={"roles:create"})
    @ApiOperation(value="Create a new role", notes="")
    public Response create(@ApiParam(name="JSON body", value="The new role to create", required=true) @Valid @NotNull RoleResponse roleResponse) {
        if (this.roleService.exists(roleResponse.name())) {
            throw new BadRequestException("Role " + roleResponse.name() + " already exists.");
        }
        Role role = new RoleImpl();
        role.setName(roleResponse.name());
        role.setPermissions(roleResponse.permissions());
        role.setDescription((String)roleResponse.description().orNull());
        try {
            role = this.roleService.save(role);
        }
        catch (ValidationException e) {
            log.error("Invalid role creation request.");
            throw new BadRequestException((Throwable)e);
        }
        URI uri = this.getUriBuilderToSelf().path(RolesResource.class).path("{rolename}").build(new Object[]{role.getName()});
        return Response.created((URI)uri).entity((Object)RoleResponse.create(role.getName(), (Optional<String>)Optional.fromNullable((Object)role.getDescription()), role.getPermissions(), role.isReadOnly())).build();
    }

    @PUT
    @Path(value="{rolename}")
    @ApiOperation(value="Update an existing role")
    public RoleResponse update(@ApiParam(name="rolename", required=true) @PathParam(value="rolename") String name, @ApiParam(name="JSON Body", value="The new representation of the role", required=true) RoleResponse role) throws NotFoundException {
        Role roleToUpdate = this.roleService.load(name);
        if (roleToUpdate.isReadOnly()) {
            throw new BadRequestException("Cannot update read only role " + name);
        }
        roleToUpdate.setName(role.name());
        roleToUpdate.setDescription((String)role.description().orNull());
        roleToUpdate.setPermissions(role.permissions());
        try {
            this.roleService.save(roleToUpdate);
        }
        catch (ValidationException e) {
            throw new BadRequestException((Throwable)e);
        }
        return RoleResponse.create(roleToUpdate.getName(), (Optional<String>)Optional.fromNullable((Object)roleToUpdate.getDescription()), roleToUpdate.getPermissions(), role.readOnly());
    }

    @DELETE
    @Path(value="{rolename}")
    @ApiOperation(value="Remove the named role and dissociate any users from it")
    public void delete(@ApiParam(name="rolename", required=true) @PathParam(value="rolename") String name) throws NotFoundException {
        this.checkPermission("roles:delete", name);
        Role role = this.roleService.load(name);
        if (role.isReadOnly()) {
            throw new BadRequestException("Cannot delete read only system role " + name);
        }
        this.userService.dissociateAllUsersFromRole(role);
        if (this.roleService.delete(name) == 0) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="{rolename}/members")
    @RequiresPermissions(value={"users:list", "roles:read"})
    @ApiOperation(value="Retrieve the role's members")
    public RoleMembershipResponse getMembers(@ApiParam(name="rolename", required=true) @PathParam(value="rolename") String name) throws NotFoundException {
        Role role = this.roleService.load(name);
        Collection<User> users = this.userService.loadAllForRole(role);
        HashSet userSummaries = Sets.newHashSetWithExpectedSize((int)users.size());
        for (User user : users) {
            Set<String> roleNames = this.userService.getRoleNames(user);
            userSummaries.add(UserSummary.create(user.getId(), user.getName(), user.getEmail(), user.getFullName(), this.isPermitted("users:permissionsedit", user.getName()) ? this.userService.getPermissionsForUser(user) : Collections.emptyList(), user.getPreferences(), ((DateTimeZone)MoreObjects.firstNonNull((Object)user.getTimeZone(), (Object)DateTimeZone.UTC)).getID(), user.getSessionTimeoutMs(), user.isReadOnly(), user.isExternalUser(), user.getStartpage(), roleNames));
        }
        return RoleMembershipResponse.create(role.getName(), userSummaries);
    }

    @PUT
    @Path(value="{rolename}/members/{username}")
    @ApiOperation(value="Add a user to a role")
    public Response addMember(@ApiParam(name="rolename") @PathParam(value="rolename") String rolename, @ApiParam(name="username") @PathParam(value="username") String username, @ApiParam(name="JSON Body", value="Placeholder because PUT requests should have a body. Set to '{}', the content will be ignored.") String body) throws NotFoundException {
        this.checkPermission("roles:edit", username);
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException("User " + username + " has not been found.");
        }
        Role role = this.roleService.load(rolename);
        HashSet roles = Sets.newHashSet(user.getRoleIds());
        roles.add(role.getId());
        user.setRoleIds(roles);
        try {
            this.userService.save(user);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Validation failed", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="{rolename}/members/{username}")
    @ApiOperation(value="Remove a user from a role")
    public Response removeMember(@ApiParam(name="rolename") @PathParam(value="rolename") String rolename, @ApiParam(name="username") @PathParam(value="username") String username) throws NotFoundException {
        this.checkPermission("roles:edit", username);
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException("User " + username + " has not been found.");
        }
        Role role = this.roleService.load(rolename);
        HashSet roles = Sets.newHashSet(user.getRoleIds());
        roles.remove(role.getId());
        user.setRoleIds(roles);
        try {
            this.userService.save(user);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Validation failed", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

