/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.messageprocessors.MessageProcessorsConfig;
import org.graylog2.messageprocessors.MessageProcessorsConfigWithDescriptors;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/MessageProcessors", description="Manage message processors")
@Path(value="/system/messageprocessors")
@Produces(value={"application/json"})
public class MessageProcessorsResource
extends RestResource {
    private final Set<String> processorClassNames;
    private final ClusterConfigService clusterConfigService;
    private final Set<MessageProcessor.Descriptor> processorDescriptors;

    @Inject
    public MessageProcessorsResource(Set<MessageProcessor.Descriptor> processorDescriptors, ClusterConfigService clusterConfigService) {
        this.processorDescriptors = processorDescriptors;
        this.processorClassNames = processorDescriptors.stream().map(MessageProcessor.Descriptor::className).collect(Collectors.toSet());
        this.clusterConfigService = clusterConfigService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get message processor configuration")
    @Path(value="config")
    public MessageProcessorsConfigWithDescriptors config() {
        this.checkPermission("clusterconfigentry:read");
        MessageProcessorsConfig config = this.clusterConfigService.getOrDefault(MessageProcessorsConfig.class, MessageProcessorsConfig.defaultConfig());
        return MessageProcessorsConfigWithDescriptors.fromConfig(config.withProcessors(this.processorClassNames), this.processorDescriptors);
    }

    @PUT
    @Timed
    @ApiOperation(value="Update message processor configuration")
    @Path(value="config")
    public MessageProcessorsConfigWithDescriptors updateConfig(@ApiParam(name="config", required=true) MessageProcessorsConfigWithDescriptors configWithDescriptors) {
        this.checkPermission("clusterconfigentry:edit");
        MessageProcessorsConfig config = configWithDescriptors.toConfig();
        this.clusterConfigService.write(config.withProcessors(this.processorClassNames));
        return configWithDescriptors;
    }
}

