/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.rest.models.system.indexer.requests.IndicesReadRequest;
import org.graylog2.rest.models.system.indexer.responses.AllIndices;
import org.graylog2.rest.models.system.indexer.responses.ClosedIndices;
import org.graylog2.rest.models.system.indexer.responses.IndexInfo;
import org.graylog2.rest.models.system.indexer.responses.IndexStats;
import org.graylog2.rest.models.system.indexer.responses.OpenIndicesInfo;
import org.graylog2.rest.models.system.indexer.responses.ShardRouting;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Indexer/Indices", description="Index information")
@Path(value="/system/indexer/indices")
public class IndicesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndicesResource.class);
    private final Indices indices;
    private final Cluster cluster;
    private final Deflector deflector;

    @Inject
    public IndicesResource(Indices indices, Cluster cluster, Deflector deflector) {
        this.indices = indices;
        this.cluster = cluster;
        this.deflector = deflector;
    }

    @GET
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Get information of an index and its shards.")
    @Produces(value={"application/json"})
    public IndexInfo single(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:read", index);
        if (!this.deflector.isGraylogIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        IndexStatistics stats = this.indices.getIndexStats(index);
        if (stats == null) {
            String msg = "Index [" + index + "] not found.";
            LOG.error(msg);
            throw new NotFoundException(msg);
        }
        ImmutableList.Builder routing = ImmutableList.builder();
        for (org.elasticsearch.cluster.routing.ShardRouting shardRouting : stats.shardRoutings()) {
            routing.add((Object)this.shardRouting(shardRouting));
        }
        return IndexInfo.create(this.indexStats(stats.primaries()), this.indexStats(stats.total()), (List<ShardRouting>)routing.build(), this.indices.isReopened(index));
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get information of all specified indices and their shards.")
    @Produces(value={"application/json"})
    public Map<String, IndexInfo> multiple(@ApiParam(name="Requested indices", required=true) @Valid @NotNull IndicesReadRequest request) {
        if (request.indices() != null) {
            return request.indices().stream().filter(this.deflector::isGraylogIndex).collect(Collectors.toMap(Function.identity(), this::single));
        }
        throw new BadRequestException("Missing or invalid list of indices passed in request.");
    }

    @GET
    @Path(value="/open")
    @Timed
    @ApiOperation(value="Get information of all open indices managed by Graylog and their shards.")
    @RequiresPermissions(value={"indices:read"})
    @Produces(value={"application/json"})
    public OpenIndicesInfo open() {
        Set indicesStats = this.indices.getIndicesStats().stream().filter(indexStats -> this.deflector.isGraylogIndex(indexStats.indexName())).collect(Collectors.toSet());
        HashMap<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
        Map<String, Boolean> areReopened = this.indices.areReopened(indicesStats.stream().map(IndexStatistics::indexName).collect(Collectors.toSet()));
        for (IndexStatistics indexStatistics : indicesStats) {
            ImmutableList.Builder routing = ImmutableList.builder();
            for (org.elasticsearch.cluster.routing.ShardRouting shardRouting : indexStatistics.shardRoutings()) {
                routing.add((Object)this.shardRouting(shardRouting));
            }
            IndexInfo indexInfo = IndexInfo.create(this.indexStats(indexStatistics.primaries()), this.indexStats(indexStatistics.total()), (List<ShardRouting>)routing.build(), areReopened.get(indexStatistics.indexName()));
            indexInfos.put(indexStatistics.indexName(), indexInfo);
        }
        return OpenIndicesInfo.create(indexInfos);
    }

    @GET
    @Timed
    @Path(value="/closed")
    @ApiOperation(value="Get a list of closed indices that can be reopened.")
    @Produces(value={"application/json"})
    public ClosedIndices closed() {
        Set<String> closedIndices = this.indices.getClosedIndices().stream().filter(indexName -> this.isPermitted("indices:read", (String)indexName) && this.deflector.isGraylogIndex((String)indexName)).collect(Collectors.toSet());
        return ClosedIndices.create(closedIndices, closedIndices.size());
    }

    @GET
    @Timed
    @Path(value="/reopened")
    @ApiOperation(value="Get a list of reopened indices, which will not be cleaned by retention cleaning")
    @Produces(value={"application/json"})
    public ClosedIndices reopened() {
        Set<String> reopenedIndices = this.indices.getReopenedIndices().stream().filter(indexName -> this.isPermitted("indices:read", (String)indexName) && this.deflector.isGraylogIndex((String)indexName)).collect(Collectors.toSet());
        return ClosedIndices.create(reopenedIndices, reopenedIndices.size());
    }

    @GET
    @Timed
    @ApiOperation(value="List all open, closed and reopened indices.")
    @Produces(value={"application/json"})
    public AllIndices all() {
        return AllIndices.create(this.closed(), this.reopened(), this.open());
    }

    @POST
    @Timed
    @Path(value="/{index}/reopen")
    @ApiOperation(value="Reopen a closed index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    public void reopen(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:changestate", index);
        if (!this.deflector.isGraylogIndex(index)) {
            LOG.info("Index [{}]\u00a0doesn't look like an index managed by Graylog.", (Object)index);
            throw new NotFoundException();
        }
        this.indices.reopenIndex(index);
    }

    @POST
    @Timed
    @Path(value="/{index}/close")
    @ApiOperation(value="Close an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot close the current deflector target index.")})
    public void close(@ApiParam(name="index") @PathParam(value="index") @NotNull String index) {
        this.checkPermission("indices:changestate", index);
        if (!this.deflector.isGraylogIndex(index)) {
            LOG.info("Index [{}]\u00a0doesn't look like an index managed by Graylog.", (Object)index);
            throw new NotFoundException();
        }
        if (index.equals(this.deflector.getCurrentActualTargetIndex())) {
            throw new ForbiddenException("The current deflector target index (" + index + ") cannot be closed");
        }
        this.indices.close(index);
    }

    @DELETE
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Delete an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot delete the current deflector target index.")})
    public void delete(@ApiParam(name="index") @PathParam(value="index") @NotNull String index) {
        this.checkPermission("indices:delete", index);
        if (!this.deflector.isGraylogIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        if (index.equals(this.deflector.getCurrentActualTargetIndex())) {
            throw new ForbiddenException("The current deflector target index (" + index + ") cannot be deleted");
        }
        this.indices.delete(index);
    }

    private ShardRouting shardRouting(org.elasticsearch.cluster.routing.ShardRouting route) {
        return ShardRouting.create(route.shardId().getId(), route.state().name().toLowerCase(Locale.ENGLISH), route.active(), route.primary(), route.currentNodeId(), this.cluster.nodeIdToName(route.currentNodeId()), this.cluster.nodeIdToHostName(route.currentNodeId()), route.relocatingNodeId());
    }

    private IndexStats indexStats(CommonStats stats) {
        return IndexStats.create(IndexStats.TimeAndTotalStats.create(stats.getFlush().getTotal(), stats.getFlush().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getGet().getCount(), stats.getGet().getTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getIndexing().getTotal().getIndexCount(), stats.getIndexing().getTotal().getIndexTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getMerge().getTotal(), stats.getMerge().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getRefresh().getTotal(), stats.getRefresh().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getSearch().getTotal().getQueryCount(), stats.getSearch().getTotal().getQueryTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getSearch().getTotal().getFetchCount(), stats.getSearch().getTotal().getFetchTime().getSeconds()), stats.getSearch().getOpenContexts(), stats.getStore().getSize().getBytes(), stats.getSegments().getCount(), IndexStats.DocsStats.create(stats.getDocs().getCount(), stats.getDocs().getDeleted()));
    }
}

