/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.logs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.log4j.MemoryAppender;
import org.graylog2.rest.models.system.loggers.responses.InternalLogMessage;
import org.graylog2.rest.models.system.loggers.responses.LogMessagesSummary;
import org.graylog2.rest.models.system.loggers.responses.LoggersSummary;
import org.graylog2.rest.models.system.loggers.responses.SingleLoggerSummary;
import org.graylog2.rest.models.system.loggers.responses.SingleSubsystemSummary;
import org.graylog2.rest.models.system.loggers.responses.SubsystemSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Loggers", description="Internal Graylog loggers")
@Path(value="/system/loggers")
public class LoggersResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LoggersResource.class);
    private static final String MEMORY_APPENDER_NAME = "graylog-internal-logs";
    private static final Map<String, Subsystem> SUBSYSTEMS = ImmutableMap.of((Object)"graylog", (Object)new Subsystem("Graylog", "org.graylog2", "All messages from Graylog-owned systems."), (Object)"indexer", (Object)new Subsystem("Indexer", "org.elasticsearch", "All messages related to indexing and searching."), (Object)"authentication", (Object)new Subsystem("Authentication", "org.apache.shiro", "All user authentication messages."), (Object)"sockets", (Object)new Subsystem("Sockets", "netty", "All messages related to socket communication."));

    @GET
    @Timed
    @ApiOperation(value="List all loggers and their current levels")
    @Produces(value={"application/json"})
    public LoggersSummary loggers() {
        Collection<LoggerConfig> loggerConfigs = this.getLoggerConfigs();
        HashMap loggers = Maps.newHashMapWithExpectedSize((int)loggerConfigs.size());
        for (LoggerConfig config : loggerConfigs) {
            if (!this.isPermitted("loggers:read", config.getName())) continue;
            Level level = config.getLevel();
            loggers.put(config.getName(), SingleLoggerSummary.create(level.toString().toLowerCase(Locale.ENGLISH), level.intLevel()));
        }
        return LoggersSummary.create(loggers);
    }

    private Collection<LoggerConfig> getLoggerConfigs() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        return configuration.getLoggers().values();
    }

    @GET
    @Timed
    @Path(value="/subsystems")
    @ApiOperation(value="List all logger subsystems and their current levels")
    @Produces(value={"application/json"})
    public SubsystemSummary subsystems() {
        HashMap subsystems = Maps.newHashMap();
        for (Map.Entry<String, Subsystem> subsystem : SUBSYSTEMS.entrySet()) {
            if (!this.isPermitted("loggers:readsubsystem", subsystem.getKey())) continue;
            try {
                String category = subsystem.getValue().getCategory();
                Level level = this.getLoggerLevel(category);
                subsystems.put(subsystem.getKey(), SingleSubsystemSummary.create(subsystem.getValue().getTitle(), subsystem.getValue().getCategory(), subsystem.getValue().getDescription(), level.toString().toLowerCase(Locale.ENGLISH), level.intLevel()));
            }
            catch (Exception e) {
                LOG.error("Error while listing logger subsystem.", (Throwable)e);
            }
        }
        return SubsystemSummary.create(subsystems);
    }

    private Level getLoggerLevel(String loggerName) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        return loggerConfig.getLevel();
    }

    private void setLoggerLevel(String loggerName, Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        config.getLoggerConfig(loggerName).setLevel(level);
        context.updateLoggers(config);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a whole subsystem", notes="Provided level is falling back to DEBUG if it does not exist")
    @ApiResponses(value={@ApiResponse(code=404, message="No such subsystem.")})
    @Path(value="/subsystems/{subsystem}/level/{level}")
    public void setSubsystemLoggerLevel(@ApiParam(name="subsystem", required=true) @PathParam(value="subsystem") @NotEmpty String subsystemTitle, @ApiParam(name="level", required=true) @PathParam(value="level") @NotEmpty String level) {
        if (!SUBSYSTEMS.containsKey(subsystemTitle)) {
            LOG.warn("No such subsystem: [{}]. Returning 404.", (Object)subsystemTitle);
            throw new NotFoundException();
        }
        this.checkPermission("loggers:editsubsystem", subsystemTitle);
        Subsystem subsystem = SUBSYSTEMS.get(subsystemTitle);
        Level newLevel = Level.toLevel((String)level.toUpperCase(Locale.ENGLISH));
        this.setLoggerLevel(subsystem.getCategory(), newLevel);
        LOG.debug("Successfully set log level for subsystem \"{}\" to \"{}\"", (Object)subsystem.getTitle(), (Object)newLevel);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a single logger", notes="Provided level is falling back to DEBUG if it does not exist")
    @Path(value="/{loggerName}/level/{level}")
    public void setSingleLoggerLevel(@ApiParam(name="loggerName", required=true) @PathParam(value="loggerName") @NotEmpty String loggerName, @ApiParam(name="level", required=true) @NotEmpty @PathParam(value="level") String level) {
        this.checkPermission("loggers:edit", loggerName);
        Level newLevel = Level.toLevel((String)level.toUpperCase(Locale.ENGLISH));
        this.setLoggerLevel(loggerName, newLevel);
        LOG.debug("Successfully set log level for logger \"{}\" to \"{}\"", (Object)loggerName, (Object)newLevel);
    }

    @GET
    @Timed
    @ApiOperation(value="Get recent internal log messages")
    @ApiResponses(value={@ApiResponse(code=404, message="Memory appender is disabled."), @ApiResponse(code=500, message="Memory appender is broken.")})
    @Path(value="/messages/recent")
    @Produces(value={"application/json"})
    public LogMessagesSummary messages(@ApiParam(name="limit", value="How many log messages should be returned", defaultValue="500", allowableValues="range[0, infinity]") @QueryParam(value="limit") @DefaultValue(value="500") @Min(value=0L) int limit, @ApiParam(name="level", value="Which log level (or higher) should the messages have", defaultValue="ALL", allowableValues="[OFF, FATAL, ERROR, WARN, INFO, DEBUG, TRACE, ALL]") @QueryParam(value="level") @DefaultValue(value="ALL") @NotEmpty String level) {
        Appender appender = this.getAppender(MEMORY_APPENDER_NAME);
        if (appender == null) {
            throw new NotFoundException("Memory appender is disabled. Please refer to the example log4j.xml file.");
        }
        if (!(appender instanceof MemoryAppender)) {
            throw new InternalServerErrorException("Memory appender is not an instance of MemoryAppender. Please refer to the example log4j.xml file.");
        }
        Level logLevel = Level.toLevel((String)level, (Level)Level.ALL);
        MemoryAppender memoryAppender = (MemoryAppender)appender;
        ArrayList<InternalLogMessage> messages = new ArrayList<InternalLogMessage>(limit);
        for (LogEvent event : memoryAppender.getLogMessages(limit)) {
            Level eventLevel = event.getLevel();
            if (!eventLevel.isMoreSpecificThan(logLevel)) continue;
            ThrowableProxy thrownProxy = event.getThrownProxy();
            String throwable = thrownProxy == null ? null : thrownProxy.getExtendedStackTraceAsString();
            Marker marker = event.getMarker();
            messages.add(InternalLogMessage.create(event.getMessage().getFormattedMessage(), event.getLoggerName(), eventLevel.toString(), marker == null ? null : marker.toString(), new DateTime(event.getTimeMillis(), DateTimeZone.UTC), throwable, event.getThreadName(), event.getContextMap()));
        }
        return LogMessagesSummary.create(messages);
    }

    private Appender getAppender(String appenderName) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        return configuration.getAppender(appenderName);
    }

    private static class Subsystem {
        private final String title;
        private final String category;
        private final String description;

        public Subsystem(String title, String category, String description) {
            this.title = title;
            this.category = category;
            this.description = description;
        }

        private String getTitle() {
            return this.title;
        }

        private String getCategory() {
            return this.category;
        }

        private String getDescription() {
            return this.description;
        }
    }
}

