/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rules;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.rules.DroolsRulesSession;
import org.graylog2.rules.RulesCompilationException;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DroolsEngine
implements RulesEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsEngine.class);
    private final KieServices kieServices;
    private final Set<URI> builtinRuleUrls;
    private KieContainer kieContainer;
    private final AtomicReference<KieSession> session = new AtomicReference();
    private final List<String> liveRules = Lists.newArrayList();
    private int version = 0;
    private ReleaseId currentReleaseId;

    @Inject
    public DroolsEngine(Set<URI> builtinRuleUrls) {
        this.builtinRuleUrls = ImmutableSet.copyOf(builtinRuleUrls);
        this.kieServices = KieServices.Factory.get();
        this.liveRules.add("// placeholder rule");
        this.commitRules();
    }

    public void stop() {
        LOG.debug("Stopping drools session and removing all rules.");
        KieSession activeSession = this.session.getAndSet(null);
        if (activeSession != null) {
            activeSession.dispose();
        }
        if (this.currentReleaseId != null) {
            this.kieServices.getRepository().removeKieModule(this.currentReleaseId);
        }
    }

    @Override
    public synchronized boolean addRule(String ruleSource) {
        LOG.debug("Adding rule {}", (Object)ruleSource);
        this.liveRules.add(ruleSource);
        if (!this.commitRules()) {
            this.liveRules.remove(ruleSource);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addRulesFromFile(String rulesFile) {
        LOG.debug("Adding drools rules from file {}", (Object)rulesFile);
        try {
            String rulesSource = Files.toString((File)new File(rulesFile), (Charset)Charsets.UTF_8);
            return this.addRule(rulesSource);
        }
        catch (IOException e) {
            LOG.warn("Could not read drools source file. Not loading rules: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public int evaluateInSharedSession(Message message) {
        KieSession kieSession = this.session.get();
        if (kieSession != null) {
            kieSession.insert((Object)message);
            return kieSession.fireAllRules();
        }
        return 0;
    }

    @Override
    public RulesEngine.RulesSession createPrivateSession() {
        KieSession kieSession = this.kieContainer.newKieSession();
        kieSession.setGlobal("log", (Object)LOG);
        return new DroolsRulesSession(kieSession);
    }

    @Override
    public Object insertFact(Object fact) {
        return this.session.get().insert(fact);
    }

    @Override
    public boolean deleteFact(Object fact) {
        FactHandle factHandle = this.session.get().getFactHandle(fact);
        if (factHandle == null) {
            return false;
        }
        this.session.get().delete(factHandle);
        return true;
    }

    private boolean commitRules() {
        ReleaseId previousReleaseId = this.currentReleaseId;
        ReleaseId newReleaseId = this.nextRulesPackageVersion();
        LOG.debug("Committing rules as version {}", (Object)newReleaseId);
        boolean deployed = this.deployRules(newReleaseId);
        if (deployed && previousReleaseId != null) {
            this.kieServices.getRepository().removeKieModule(previousReleaseId);
        }
        return deployed;
    }

    private boolean deployRules(ReleaseId newReleaseId) {
        try {
            String[] drls = new String[this.liveRules.size()];
            int i = 0;
            for (String drl : this.liveRules) {
                drls[i] = "package org.graylog2.rules\nimport org.graylog2.plugin.*\nglobal org.slf4j.Logger log\n\n" + drl;
                ++i;
            }
            this.createAndDeployJar(this.kieServices, newReleaseId, drls);
            if (this.kieContainer == null) {
                this.kieContainer = this.kieServices.newKieContainer(newReleaseId);
                KieSession session = this.kieContainer.newKieSession();
                this.session.set(session);
                session.setGlobal("log", (Object)LOG);
            }
            this.kieContainer.updateToVersion(newReleaseId);
            return true;
        }
        catch (RulesCompilationException e) {
            LOG.warn("Unable to add rules due to compilation errors.", (Throwable)e);
            return false;
        }
    }

    private ReleaseId nextRulesPackageVersion() {
        this.currentReleaseId = this.kieServices.newReleaseId("org.graylog2", "dynamic-rules", Integer.toString(this.version++));
        return this.currentReleaseId;
    }

    private KieModule createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) throws RulesCompilationException {
        byte[] jar = this.createKJar(ks, releaseId, null, drls);
        return this.deployJar(ks, jar);
    }

    private byte[] createKJar(KieServices ks, ReleaseId releaseId, String pom, String ... drls) throws RulesCompilationException {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write("pom.xml", pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        for (URI builtinRuleUrl : this.builtinRuleUrls) {
            URL url;
            String rulesFileName = FilenameUtils.getName((String)builtinRuleUrl.getPath());
            String path = "src/main/resources/" + rulesFileName;
            try {
                url = builtinRuleUrl.toURL();
            }
            catch (MalformedURLException e) {
                throw new RulesCompilationException(Collections.emptyList());
            }
            Resource resource = ResourceFactory.newUrlResource((URL)url).setSourcePath(path).setResourceType(ResourceType.DRL);
            kfs.write(resource);
        }
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RulesCompilationException(kb.getResults().getMessages());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        return kieModule.getBytes();
    }

    private KieModule deployJar(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        return ks.getRepository().addKieModule(jarRes, new Resource[0]);
    }
}

