/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.inject.Inject;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.TrustAllX509TrustManager;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.security.ldap.LdapEntry;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserAuthenticator.class);
    private final LdapConnector ldapConnector;
    private final LdapSettingsService ldapSettingsService;
    private final UserService userService;

    @Inject
    public LdapUserAuthenticator(LdapConnector ldapConnector, LdapSettingsService ldapSettingsService, UserService userService) {
        this.ldapConnector = ldapConnector;
        this.userService = userService;
        this.ldapSettingsService = ldapSettingsService;
        this.setAuthenticationTokenClass(UsernamePasswordToken.class);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authtoken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authtoken;
        LdapConnectionConfig config = new LdapConnectionConfig();
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        if (ldapSettings == null || !ldapSettings.isEnabled()) {
            LOG.trace("LDAP is disabled, skipping");
            return null;
        }
        config.setLdapHost(ldapSettings.getUri().getHost());
        config.setLdapPort(ldapSettings.getUri().getPort());
        config.setUseSsl(ldapSettings.getUri().getScheme().startsWith("ldaps"));
        config.setUseTls(ldapSettings.isUseStartTls());
        if (ldapSettings.isTrustAllCertificates()) {
            config.setTrustManagers(new TrustManager[]{new TrustAllX509TrustManager()});
        }
        config.setName(ldapSettings.getSystemUserName());
        config.setCredentials(ldapSettings.getSystemPassword());
        String principal = (String)token.getPrincipal();
        if (Strings.isNullOrEmpty((String)principal) || token.getPassword() == null) {
            return null;
        }
        LdapNetworkConnection connection = null;
        try {
            connection = this.ldapConnector.connect(config);
            if (null == connection) {
                LOG.error("Couldn't connect to LDAP directory");
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            String password = String.valueOf(token.getPassword());
            LdapEntry userEntry = this.ldapConnector.search(connection, ldapSettings.getSearchBase(), ldapSettings.getSearchPattern(), ldapSettings.getDisplayNameAttribute(), principal, ldapSettings.isActiveDirectory(), ldapSettings.getGroupSearchBase(), ldapSettings.getGroupIdAttribute(), ldapSettings.getGroupSearchPattern());
            if (userEntry == null) {
                LOG.debug("User {} not found in LDAP", (Object)principal);
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            boolean authenticated = this.ldapConnector.authenticate(connection, userEntry.getDn(), password);
            if (!authenticated) {
                LOG.info("Invalid credentials for user {} (DN {})", (Object)principal, (Object)userEntry.getDn());
                AuthenticationInfo e = null;
                return e;
            }
            User user = this.userService.syncFromLdapEntry(userEntry, ldapSettings, principal);
            if (user == null) {
                LOG.error("Unable to sync LDAP user {} (DN {})", (Object)userEntry.getBindPrincipal(), (Object)userEntry.getDn());
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            SimpleAccount simpleAccount = new SimpleAccount((Object)principal, null, "ldap realm");
            return simpleAccount;
        }
        catch (LdapException e) {
            LOG.error("LDAP error", (Throwable)e);
        }
        catch (CursorException e) {
            LOG.error("Unable to read LDAP entry", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error during LDAP user account sync. Cannot log in user {}", (Object)principal, (Object)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close LDAP connection", (Throwable)e);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.ldapSettingsService.load().isEnabled();
    }
}

