/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.plugins;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.PluginModule;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private final File pluginDir;
    private final ChainingClassLoader classLoader;

    public PluginLoader(File pluginDir, ChainingClassLoader classLoader) {
        this.pluginDir = Objects.requireNonNull(pluginDir);
        this.classLoader = Objects.requireNonNull(classLoader);
    }

    public Set<Plugin> loadPlugins() {
        return ImmutableSortedSet.orderedBy((Comparator)new PluginComparator()).addAll(Iterables.transform(this.loadJarPlugins(), (Function)new PluginAdapterFunction())).addAll(Iterables.transform(this.loadClassPathPlugins(), (Function)new PluginAdapterFunction())).build();
    }

    private Iterable<Plugin> loadClassPathPlugins() {
        return ServiceLoader.load(Plugin.class);
    }

    private Iterable<Plugin> loadJarPlugins() {
        if (!this.pluginDir.exists()) {
            LOG.warn("Plugin directory {} does not exist, not loading plugins.", (Object)this.pluginDir.getAbsolutePath());
            return Collections.emptySet();
        }
        if (!this.pluginDir.isDirectory()) {
            LOG.warn("Path {} is not a directory, cannot load plugins.", (Object)this.pluginDir);
            return Collections.emptySet();
        }
        LOG.debug("Scanning directory <{}> for plugins...", (Object)this.pluginDir.getAbsolutePath());
        File[] files = this.pluginDir.listFiles();
        if (files == null) {
            LOG.warn("Could not list files in {}, cannot load plugins.", (Object)this.pluginDir);
            return Collections.emptySet();
        }
        LOG.debug("Loading [{}] plugins", (Object)files.length);
        ImmutableSet.Builder plugins = ImmutableSet.builder();
        for (File jar : files) {
            if (!jar.isFile()) {
                LOG.debug("{} is not a file, skipping.", (Object)jar);
                continue;
            }
            try {
                LOG.debug("Loading <" + jar.getAbsolutePath() + ">");
                URLClassLoader pluginClassLoader = URLClassLoader.newInstance(new URL[]{jar.toURI().toURL()});
                this.classLoader.addClassLoader(pluginClassLoader);
                ServiceLoader<Plugin> pluginServiceLoader = ServiceLoader.load(Plugin.class, this.classLoader);
                plugins.addAll(pluginServiceLoader);
            }
            catch (MalformedURLException e) {
                LOG.error("Cannot open JAR file for discovering plugins", (Throwable)e);
            }
        }
        return plugins.build();
    }

    private static class PluginAdapterFunction
    implements Function<Plugin, Plugin> {
        private PluginAdapterFunction() {
        }

        public Plugin apply(Plugin input) {
            return new PluginAdapter(input);
        }
    }

    public static class PluginAdapter
    implements Plugin {
        private final Plugin plugin;

        public PluginAdapter(Plugin plugin) {
            this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin);
        }

        @Override
        public PluginMetaData metadata() {
            return this.plugin.metadata();
        }

        @Override
        public Collection<PluginModule> modules() {
            return this.plugin.modules();
        }

        public String getPluginClassName() {
            return this.plugin.getClass().getCanonicalName();
        }

        public int hashCode() {
            return Objects.hash(this.plugin.metadata().getUniqueId());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Plugin) {
                Plugin that = (Plugin)obj;
                return Objects.equals(this.metadata().getUniqueId(), that.metadata().getUniqueId());
            }
            return false;
        }

        public String toString() {
            PluginMetaData metadata = this.plugin.metadata();
            return metadata.getName() + " " + metadata.getVersion() + " [" + metadata.getUniqueId() + "]";
        }
    }

    public static class PluginComparator
    implements Comparator<Plugin> {
        @Override
        public int compare(Plugin o1, Plugin o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.metadata().getUniqueId()), (Comparable)((Object)o2.metadata().getUniqueId())).compare((Comparable)((Object)o1.metadata().getName()), (Comparable)((Object)o2.metadata().getName())).compare((Comparable)o1.metadata().getVersion(), (Comparable)o2.metadata().getVersion()).result();
        }
    }
}

