/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import org.glassfish.grizzly.http.server.Response;
import org.graylog2.rest.RestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAccessLogFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.graylog2.rest.accesslog");
    private final Response response;

    public RestAccessLogFilter(@Context Response response) {
        this.response = Objects.requireNonNull(response);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            try {
                String rawQuery = requestContext.getUriInfo().getRequestUri().getRawQuery();
                Date requestDate = requestContext.getDate();
                String userName = RestTools.getUserNameFromRequest(requestContext);
                LOG.debug("{} {} [{}] \"{} {}{}\" {} {} {}", new Object[]{this.response.getRequest().getRemoteAddr(), userName == null ? "-" : userName, requestDate == null ? "-" : requestDate, requestContext.getMethod(), requestContext.getUriInfo().getPath(), rawQuery == null ? "" : "?" + rawQuery, requestContext.getHeaderString("User-Agent"), responseContext.getStatus(), responseContext.getLength()});
            }
            catch (Exception e) {
                LOG.error("Error while processing REST API access log", (Throwable)e);
            }
        }
    }
}

