/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.tls;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import org.graylog2.shared.security.tls.ThreadLocalInsecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class SelfSignedCertificate {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedCertificate.class);
    static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    static final Date NOT_AFTER = new Date(253402300799000L);
    private final Certificate certificate;
    private final PrivateKey privateKey;
    private final KeyStore keyStore;

    private SelfSignedCertificate(PrivateKey privateKey, Certificate certificate, KeyStore keyStore) throws CertificateException {
        this.privateKey = Objects.requireNonNull(privateKey);
        this.certificate = Objects.requireNonNull(certificate);
        this.keyStore = Objects.requireNonNull(keyStore);
    }

    public Certificate certificate() {
        return this.certificate;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public KeyStore keyStore() {
        return this.keyStore;
    }

    public static SelfSignedCertificate create() throws GeneralSecurityException, IOException {
        return SelfSignedCertificate.create("example.com", "password");
    }

    public static SelfSignedCertificate create(String fqdn, String password) throws GeneralSecurityException, IOException {
        return SelfSignedCertificate.create(fqdn, ThreadLocalInsecureRandom.current(), 1024, password);
    }

    public static SelfSignedCertificate create(String fqdn, SecureRandom random, int bits, String password) throws GeneralSecurityException, IOException {
        X509Certificate certificate;
        if (Strings.isNullOrEmpty((String)fqdn)) {
            throw new IllegalArgumentException("FQDN must not be empty");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("Key store password must not be empty");
        }
        KeyPair keypair = SelfSignedCertificate.generateKeyPair(random, bits);
        PrivateKey privateKey = keypair.getPrivate();
        try {
            certificate = SelfSignedCertificate.generateCertificate(fqdn, keypair, random);
        }
        catch (Throwable t) {
            LOG.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", t);
            throw new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.");
        }
        KeyStore keyStore = SelfSignedCertificate.generateKeyStore(fqdn, privateKey, certificate, password);
        return new SelfSignedCertificate(privateKey, certificate, keyStore);
    }

    private static KeyPair generateKeyPair(SecureRandom random, int bits) {
        KeyPair keypair;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(bits, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        return keypair;
    }

    private static X509Certificate generateCertificate(String fqdn, KeyPair keypair, SecureRandom random) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        X500Name owner = new X500Name("CN=" + fqdn);
        info.set("version", new CertificateVersion(2));
        info.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, random)));
        try {
            info.set("subject", new CertificateSubjectName(owner));
        }
        catch (CertificateException ignore) {
            info.set("subject", owner);
        }
        try {
            info.set("issuer", new CertificateIssuerName(owner));
        }
        catch (CertificateException ignore) {
            info.set("issuer", owner);
        }
        info.set("validity", new CertificateValidity(NOT_BEFORE, NOT_AFTER));
        info.set("key", new CertificateX509Key(keypair.getPublic()));
        info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid)));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        info.set("algorithmID.algorithm", cert.get("x509.algorithm"));
        cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        cert.verify(keypair.getPublic());
        return cert;
    }

    private static KeyStore generateKeyStore(String fqdn, PrivateKey privateKey, Certificate certificate, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, password.toCharArray());
        keyStore.setKeyEntry(fqdn, privateKey, password.toCharArray(), new Certificate[]{certificate});
        return keyStore;
    }
}

