/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.floreysoft.jmte.Engine;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.graylog2.Configuration;

@Path(value="/config.js")
public class AppConfigResource {
    private static final String CK_OVERRIDE_SERVER_URI = "X-Graylog-Server-URL";
    private static final Engine engine = new Engine();
    private final Configuration configuration;

    @Inject
    public AppConfigResource(Configuration configuration) {
        this.configuration = configuration;
    }

    @GET
    @Produces(value={"application/javascript"})
    public String get(final @Context HttpHeaders headers) {
        String template;
        URL templateUrl = this.getClass().getResource("/web-interface/config.js.template");
        try {
            template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read AppConfig template while generating web interface configuration: ", e);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(){
            {
                this.put("rootTimeZone", AppConfigResource.this.configuration.getRootTimeZone());
                this.put("serverUri", AppConfigResource.this.buildEndpointUri(headers));
                this.put("appPathPrefix", "");
            }
        };
        return engine.transform(template, (Map)model);
    }

    private String buildEndpointUri(HttpHeaders httpHeaders) {
        Optional<String> endpointUri = Optional.empty();
        List headers = httpHeaders.getRequestHeader(CK_OVERRIDE_SERVER_URI);
        if (headers != null && !headers.isEmpty()) {
            endpointUri = headers.stream().filter(s -> {
                try {
                    URL url = new URL((String)s);
                    switch (url.getProtocol()) {
                        case "http": 
                        case "https": {
                            return true;
                        }
                    }
                    return false;
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }).findFirst();
        }
        return endpointUri.orElse(this.configuration.getWebEndpointUri().toString());
    }
}

