
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_EsIndexRange extends EsIndexRange {

  private final String indexName;
  private final DateTime begin;
  private final DateTime end;
  private final DateTime calculatedAt;
  private final int calculationDuration;

  AutoValue_EsIndexRange(
      String indexName,
      DateTime begin,
      DateTime end,
      DateTime calculatedAt,
      int calculationDuration) {
    if (indexName == null) {
      throw new NullPointerException("Null indexName");
    }
    this.indexName = indexName;
    if (begin == null) {
      throw new NullPointerException("Null begin");
    }
    this.begin = begin;
    if (end == null) {
      throw new NullPointerException("Null end");
    }
    this.end = end;
    if (calculatedAt == null) {
      throw new NullPointerException("Null calculatedAt");
    }
    this.calculatedAt = calculatedAt;
    this.calculationDuration = calculationDuration;
  }

  @JsonProperty(value = "gl2_index_range_index_name")
  @Override
  public String indexName() {
    return indexName;
  }

  @JsonProperty(value = "gl2_index_range_begin")
  @Override
  public DateTime begin() {
    return begin;
  }

  @JsonProperty(value = "gl2_index_range_end")
  @Override
  public DateTime end() {
    return end;
  }

  @JsonProperty(value = "gl2_index_range_calculated_at")
  @Override
  public DateTime calculatedAt() {
    return calculatedAt;
  }

  @JsonProperty(value = "gl2_index_range_took_ms")
  @Override
  public int calculationDuration() {
    return calculationDuration;
  }

  @Override
  public String toString() {
    return "EsIndexRange{"
        + "indexName=" + indexName + ", "
        + "begin=" + begin + ", "
        + "end=" + end + ", "
        + "calculatedAt=" + calculatedAt + ", "
        + "calculationDuration=" + calculationDuration
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EsIndexRange) {
      EsIndexRange that = (EsIndexRange) o;
      return (this.indexName.equals(that.indexName()))
           && (this.begin.equals(that.begin()))
           && (this.end.equals(that.end()))
           && (this.calculatedAt.equals(that.calculatedAt()))
           && (this.calculationDuration == that.calculationDuration());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.indexName.hashCode();
    h *= 1000003;
    h ^= this.begin.hashCode();
    h *= 1000003;
    h ^= this.end.hashCode();
    h *= 1000003;
    h ^= this.calculatedAt.hashCode();
    h *= 1000003;
    h ^= this.calculationDuration;
    return h;
  }

}
