
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_AbsoluteRange extends AbsoluteRange {

  private final String type;
  private final DateTime from;
  private final DateTime to;

  private AutoValue_AbsoluteRange(
      String type,
      DateTime from,
      DateTime to) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (from == null) {
      throw new NullPointerException("Null from");
    }
    this.from = from;
    if (to == null) {
      throw new NullPointerException("Null to");
    }
    this.to = to;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public DateTime from() {
    return from;
  }

  @JsonProperty
  @Override
  public DateTime to() {
    return to;
  }

  @Override
  public String toString() {
    return "AbsoluteRange{"
        + "type=" + type + ", "
        + "from=" + from + ", "
        + "to=" + to
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AbsoluteRange) {
      AbsoluteRange that = (AbsoluteRange) o;
      return (this.type.equals(that.type()))
           && (this.from.equals(that.from()))
           && (this.to.equals(that.to()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= this.from.hashCode();
    h *= 1000003;
    h ^= this.to.hashCode();
    return h;
  }

  static final class Builder extends AbsoluteRange.Builder {
    private String type;
    private DateTime from;
    private DateTime to;
    Builder() {
    }
    Builder(AbsoluteRange source) {
      this.type = source.type();
      this.from = source.from();
      this.to = source.to();
    }
    @Override
    public AbsoluteRange.Builder type(String type) {
      this.type = type;
      return this;
    }
    @Override
    public AbsoluteRange.Builder from(DateTime from) {
      this.from = from;
      return this;
    }
    @Override
    public AbsoluteRange.Builder to(DateTime to) {
      this.to = to;
      return this;
    }
    @Override
    public AbsoluteRange build() {
      String missing = "";
      if (type == null) {
        missing += " type";
      }
      if (from == null) {
        missing += " from";
      }
      if (to == null) {
        missing += " to";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AbsoluteRange(
          this.type,
          this.from,
          this.to);
    }
  }

}
