/**
 * This file is part of Graylog.
 *
 * Graylog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Graylog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Graylog.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.graylog2.security.realm;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.PasswordAlgorithmFactory;

import javax.inject.Inject;

public class PasswordAlgorithmCredentialsMatcher extends SimpleCredentialsMatcher {
    private final PasswordAlgorithmFactory passwordAlgorithmFactory;

    @Inject
    public PasswordAlgorithmCredentialsMatcher(PasswordAlgorithmFactory passwordAlgorithmFactory) {
        this.passwordAlgorithmFactory = passwordAlgorithmFactory;
    }

    @Override
    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        if (token instanceof UsernamePasswordToken && info instanceof UserAccount) {
            final UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
            final UserAccount userAccount = (UserAccount)info;
            final User user = userAccount.getUser();

            return user.isUserPassword(String.valueOf(usernamePasswordToken.getPassword()));
        } else {
            return false;
        }
    }
}
