/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.node.GraylogNode;
import org.elasticsearch.node.Node;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.esplugin.MonitorPlugin;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EsNodeProvider
implements Provider<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(EsNodeProvider.class);
    private final ElasticsearchConfiguration configuration;
    private final NodeId nodeId;

    @Inject
    public EsNodeProvider(ElasticsearchConfiguration configuration, NodeId nodeId) {
        this.configuration = Objects.requireNonNull(configuration);
        this.nodeId = Objects.requireNonNull(nodeId);
    }

    public Node get() {
        return new GraylogNode(EsNodeProvider.readNodeSettings(this.configuration, this.nodeId), Collections.singleton(MonitorPlugin.class));
    }

    public static Settings readNodeSettings(ElasticsearchConfiguration conf, NodeId nodeId) {
        Path esConfigFile;
        Settings.Builder settings = Settings.builder();
        settings.put("cluster.name", conf.getClusterName());
        settings.put("node.name", conf.getNodeNamePrefix() + nodeId);
        settings.put("node.master", conf.isMasterNode());
        settings.put("node.data", conf.isDataNode());
        settings.put("node.client", true);
        settings.put("path.home", conf.getPathHome());
        if (!Strings.isNullOrEmpty((String)conf.getPathData())) {
            settings.put("path.data", conf.getPathData());
        }
        settings.put("action.auto_create_index", false);
        settings.put("http.enabled", conf.isHttpEnabled());
        settings.put("transport.tcp.port", conf.getTransportTcpPort());
        settings.put("discovery.initial_state_timeout", conf.getInitialStateTimeout());
        List<String> unicastHosts = conf.getUnicastHosts();
        if (unicastHosts != null && !unicastHosts.isEmpty()) {
            String[] trimmedHosts = new String[unicastHosts.size()];
            for (int i = 0; i < unicastHosts.size(); ++i) {
                String host = unicastHosts.get(i);
                trimmedHosts[i] = host.trim();
            }
            settings.putArray("discovery.zen.ping.unicast.hosts", trimmedHosts);
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkHost())) {
            settings.put("network.host", conf.getNetworkHost());
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkBindHost())) {
            settings.put("network.bind_host", conf.getNetworkBindHost());
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkPublishHost())) {
            settings.put("network.publish_host", conf.getNetworkPublishHost());
        }
        if ((esConfigFile = conf.getConfigFile()) != null) {
            try {
                settings.loadFromPath(esConfigFile);
            }
            catch (SettingsException e) {
                LOG.warn("Cannot read Elasticsearch configuration from " + esConfigFile, (Throwable)e);
            }
        }
        return settings.build();
    }
}

