/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.buffers.processors;

import com.codahale.metrics.MetricRegistry;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.messageprocessors.OrderedMessageProcessors;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProcessBufferProcessor
extends ProcessBufferProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ServerProcessBufferProcessor.class);
    private final OrderedMessageProcessors orderedMessageProcessors;
    private final OutputBuffer outputBuffer;

    @Inject
    public ServerProcessBufferProcessor(MetricRegistry metricRegistry, OrderedMessageProcessors orderedMessageProcessors, OutputBuffer outputBuffer) {
        super(metricRegistry);
        this.orderedMessageProcessors = orderedMessageProcessors;
        this.outputBuffer = outputBuffer;
    }

    @Override
    protected void handleMessage(@Nonnull Message msg) {
        Messages messages = msg;
        for (MessageProcessor messageProcessor : this.orderedMessageProcessors) {
            messages = messageProcessor.process(messages);
        }
        for (Message message : messages) {
            LOG.debug("Finished processing message. Writing to output buffer.");
            this.outputBuffer.insertBlocking(message);
        }
    }
}

