/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bundles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterators;
import com.mongodb.DBCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.BundleExporterProvider;
import org.graylog2.bindings.providers.BundleImporterProvider;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.bundles.BundleExporter;
import org.graylog2.bundles.BundleImporter;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.ExportBundle;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.users.User;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

@Singleton
public class BundleService {
    private static final String COLLECTION_NAME = "content_packs";
    private final JacksonDBCollection<ConfigurationBundle, ObjectId> dbCollection;
    private final BundleImporterProvider bundleImporterProvider;
    private final BundleExporterProvider bundleExporterProvider;

    @Inject
    public BundleService(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, BundleImporterProvider bundleImporterProvider, BundleExporterProvider bundleExporterProvider) {
        this((JacksonDBCollection<ConfigurationBundle, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ConfigurationBundle.class, ObjectId.class, (ObjectMapper)mapperProvider.get()), bundleImporterProvider, bundleExporterProvider);
    }

    public BundleService(JacksonDBCollection<ConfigurationBundle, ObjectId> dbCollection, BundleImporterProvider bundleImporterProvider, BundleExporterProvider bundleExporterProvider) {
        this.dbCollection = dbCollection;
        this.bundleImporterProvider = bundleImporterProvider;
        this.bundleExporterProvider = bundleExporterProvider;
    }

    public ConfigurationBundle load(String bundleId) throws NotFoundException {
        ConfigurationBundle bundle = (ConfigurationBundle)this.dbCollection.findOneById((Object)new ObjectId(bundleId));
        if (bundle == null) {
            throw new NotFoundException();
        }
        return bundle;
    }

    public ConfigurationBundle findByNameAndCategory(String name, String category) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"name", (Object)name).is("category", (Object)category);
        return (ConfigurationBundle)this.dbCollection.findOne(query);
    }

    public Set<ConfigurationBundle> loadAll() {
        DBCursor ConfigurationBundles = this.dbCollection.find();
        HashSet<ConfigurationBundle> bundles = new HashSet<ConfigurationBundle>();
        if (ConfigurationBundles.hasNext()) {
            Iterators.addAll(bundles, (Iterator)ConfigurationBundles);
        }
        return bundles;
    }

    public boolean update(String bundleId, ConfigurationBundle bundle) {
        WriteResult result = this.dbCollection.updateById((Object)new ObjectId(bundleId), (Object)bundle);
        return result.getN() == 1;
    }

    public ConfigurationBundle insert(ConfigurationBundle bundle) {
        WriteResult writeResult = this.dbCollection.insert((Object)bundle);
        return (ConfigurationBundle)writeResult.getSavedObject();
    }

    public int delete(String bundleId) {
        return this.dbCollection.removeById((Object)new ObjectId(bundleId)).getN();
    }

    public void applyConfigurationBundle(String bundleId, User actingUser) throws NotFoundException {
        this.applyConfigurationBundle(this.load(bundleId), actingUser);
    }

    public void applyConfigurationBundle(ConfigurationBundle bundle, User actingUser) {
        String userName = actingUser.getName();
        BundleImporter bundleImporter = this.bundleImporterProvider.get();
        bundleImporter.runImport(bundle, userName);
    }

    public ConfigurationBundle exportConfigurationBundle(ExportBundle exportBundle) {
        BundleExporter bundleExporter = this.bundleExporterProvider.get();
        return bundleExporter.export(exportBundle);
    }

    public long count() {
        return this.dbCollection.count();
    }
}

