/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetStrategyFactory;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;

public class WidgetResultCache {
    private final ConcurrentMap<String, Supplier<ComputationResult>> cache;
    private final MetricRegistry metricRegistry;
    private final WidgetStrategyFactory widgetStrategyFactory;
    private final Counter counter;

    @Inject
    public WidgetResultCache(MetricRegistry metricRegistry, WidgetStrategyFactory widgetStrategyFactory) {
        this.metricRegistry = metricRegistry;
        this.widgetStrategyFactory = widgetStrategyFactory;
        this.cache = Maps.newConcurrentMap();
        this.counter = metricRegistry.counter(MetricRegistry.name(this.getClass(), (String[])new String[]{"cacheEntries"}));
    }

    public ComputationResult getComputationResultForDashboardWidget(DashboardWidget dashboardWidget) throws InvalidWidgetConfigurationException {
        WidgetStrategy widgetStrategy;
        Supplier<ComputationResult> supplier;
        String widgetId = dashboardWidget.getId();
        if (!this.cache.containsKey(widgetId) && (supplier = this.cache.putIfAbsent(widgetId, (Supplier<ComputationResult>)Suppliers.memoizeWithExpiration((Supplier)new ComputationResultSupplier(this.metricRegistry, dashboardWidget, widgetStrategy = this.widgetStrategyFactory.getWidgetForType(dashboardWidget.getType().toString(), dashboardWidget.getConfig(), dashboardWidget.getTimeRange(), widgetId)), (long)dashboardWidget.getCacheTime(), (TimeUnit)TimeUnit.SECONDS))) == null) {
            this.counter.inc();
        }
        return (ComputationResult)((Supplier)this.cache.get(widgetId)).get();
    }

    public void invalidate(DashboardWidget dashboardWidget) {
        this.cache.remove(dashboardWidget.getId());
        this.counter.dec();
    }

    private class ComputationResultSupplier
    implements Supplier<ComputationResult> {
        private final MetricRegistry metricRegistry;
        private final DashboardWidget dashboardWidget;
        private final WidgetStrategy widgetStrategy;

        public ComputationResultSupplier(MetricRegistry metricRegistry, DashboardWidget dashboardWidget, WidgetStrategy widgetStrategy) {
            this.metricRegistry = metricRegistry;
            this.dashboardWidget = dashboardWidget;
            this.widgetStrategy = widgetStrategy;
        }

        /*
         * Loose catch block
         */
        public ComputationResult get() {
            try {
                try (Timer.Context timer = this.getCalculationTimer().time();){
                    ComputationResult computationResult = this.widgetStrategy.compute();
                    return computationResult;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.getCalculationMeter().mark();
            }
        }

        private Timer getCalculationTimer() {
            return this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{this.dashboardWidget.getId(), "calculationTime"}));
        }

        private Meter getCalculationMeter() {
            return this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{this.dashboardWidget.getId(), "calculations"}));
        }
    }
}

