/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsResult
extends IndexQueryResult {
    private final long total;
    private final long missing;
    private final long other;
    private final Map<String, Long> terms;

    public TermsResult(Terms f, Missing m, long totalCount, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.total = totalCount;
        this.missing = m.getDocCount();
        this.other = f.getSumOfOtherDocCounts();
        this.terms = this.buildTermsMap(f.getBuckets());
    }

    private Map<String, Long> buildTermsMap(List<Terms.Bucket> entries) {
        HashMap terms = Maps.newHashMap();
        for (Terms.Bucket bucket : entries) {
            terms.put(bucket.getKeyAsString(), bucket.getDocCount());
        }
        return terms;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMissing() {
        return this.missing;
    }

    public long getOther() {
        return this.other;
    }

    public Map<String, Long> getTerms() {
        return this.terms;
    }
}

