/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.inputs.codecs.GelfChunkAggregator;
import org.graylog2.inputs.codecs.gelf.GELFMessage;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="gelf", displayName="GELF")
public class GelfCodec
extends AbstractCodec {
    private static final Logger log = LoggerFactory.getLogger(GelfCodec.class);
    private final GelfChunkAggregator aggregator;
    private final ObjectMapper objectMapper;

    @Inject
    public GelfCodec(@Assisted Configuration configuration, GelfChunkAggregator aggregator) {
        super(configuration);
        this.aggregator = aggregator;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    private static String stringValue(JsonNode json, String fieldName) {
        JsonNode value;
        if (json != null && (value = json.get(fieldName)) != null) {
            return value.asText();
        }
        return null;
    }

    private static long longValue(JsonNode json, String fieldName) {
        JsonNode value;
        if (json != null && (value = json.get(fieldName)) != null) {
            return value.asLong(-1L);
        }
        return -1L;
    }

    private static int intValue(JsonNode json, String fieldName) {
        JsonNode value;
        if (json != null && (value = json.get(fieldName)) != null) {
            return value.asInt(-1);
        }
        return -1;
    }

    private static double doubleValue(JsonNode json, String fieldName) {
        JsonNode value;
        if (json != null && (value = json.get(fieldName)) != null) {
            return value.asDouble(-1.0);
        }
        return -1.0;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        String facility;
        int level;
        long line;
        JsonNode node;
        GELFMessage gelfMessage = new GELFMessage(rawMessage.getPayload(), rawMessage.getRemoteAddress());
        String json = gelfMessage.getJSON();
        try {
            node = this.objectMapper.readTree(json);
        }
        catch (Exception e) {
            log.error("Could not parse JSON, first 400 characters: " + StringUtils.abbreviate((String)json, (int)403), (Throwable)e);
            throw new IllegalStateException("JSON is null/could not be parsed (invalid JSON)", e);
        }
        double messageTimestamp = GelfCodec.doubleValue(node, "timestamp");
        DateTime timestamp = messageTimestamp <= 0.0 ? rawMessage.getTimestamp() : Tools.dateTimeFromDouble(messageTimestamp);
        Message message = new Message(GelfCodec.stringValue(node, "short_message"), GelfCodec.stringValue(node, "host"), timestamp);
        message.addField("full_message", GelfCodec.stringValue(node, "full_message"));
        String file = GelfCodec.stringValue(node, "file");
        if (file != null && !file.isEmpty()) {
            message.addField("file", file);
        }
        if ((line = GelfCodec.longValue(node, "line")) > -1L) {
            message.addField("line", line);
        }
        if ((level = GelfCodec.intValue(node, "level")) > -1) {
            message.addField("level", level);
        }
        if ((facility = GelfCodec.stringValue(node, "facility")) != null && !facility.isEmpty()) {
            message.addField("facility", facility);
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Object fieldValue;
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if ("version".equals(key)) continue;
            if (key.startsWith("_") && key.length() > 1) {
                key = key.substring(1);
            }
            if (key.equals("short_message") || key.equals("host") || message.getField(key) != null || Message.RESERVED_FIELDS.contains((Object)key) && !Message.RESERVED_SETTABLE_FIELDS.contains((Object)key)) continue;
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isContainerNode()) {
                fieldValue = value.toString();
            } else if (value.isFloatingPointNumber()) {
                fieldValue = value.asDouble();
            } else if (value.isIntegralNumber()) {
                fieldValue = value.asLong();
            } else {
                if (value.isNull()) {
                    log.debug("Field [{}] is NULL. Skipping.", (Object)key);
                    continue;
                }
                if (value.isTextual()) {
                    fieldValue = value.asText();
                } else {
                    log.debug("Field [{}] has unknown value type. Skipping.", (Object)key);
                    continue;
                }
            }
            message.addField(key, fieldValue);
        }
        return message;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return this.aggregator;
    }

    public static class Descriptor
    extends AbstractCodec.Descriptor {
        @Inject
        public Descriptor() {
            super(GelfCodec.class.getAnnotation(Codec.class).displayName());
        }
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
            if (cr.containsField("port")) {
                cr.getField("port").setDefaultValue(12201);
            }
            if (cr.containsField("use_null_delimiter")) {
                cr.getField("use_null_delimiter").setDefaultValue(true);
            }
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<GelfCodec> {
        @Override
        public GelfCodec create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

