/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs.gelf;

import org.graylog2.inputs.codecs.gelf.GELFMessage;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public final class GELFMessageChunk {
    public static final int HEADER_PART_SEQNUM_START = 10;
    public static final int HEADER_PART_SEQCNT_START = 11;
    public static final int HEADER_PART_HASH_START = 2;
    public static final int HEADER_PART_HASH_LENGTH = 8;
    public static final int HEADER_TOTAL_LENGTH = 12;
    private String id;
    private byte[] data = new byte[1];
    private int sequenceNumber = -1;
    private int sequenceCount = -1;
    private long arrival = -1L;
    private final ChannelBuffer payload;
    private final MessageInput sourceInput;

    public GELFMessageChunk(byte[] payload, MessageInput sourceInput) {
        if (payload.length < 12) {
            throw new IllegalArgumentException("This GELF message chunk is too short. Cannot even contain the required header.");
        }
        this.payload = ChannelBuffers.wrappedBuffer((byte[])payload);
        this.sourceInput = sourceInput;
        this.read();
    }

    public GELFMessageChunk(GELFMessage msg, MessageInput sourceInput) {
        this(msg.getPayload(), sourceInput);
    }

    public long getArrival() {
        return this.arrival;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MessageInput getSourceInput() {
        return this.sourceInput;
    }

    private void read() {
        this.extractId();
        this.extractSequenceCount();
        this.extractSequenceNumber();
        this.extractData();
        this.arrival = Tools.nowUTC().getMillis();
    }

    private String extractId() {
        if (this.id == null) {
            this.id = ChannelBuffers.hexDump((ChannelBuffer)this.payload, (int)2, (int)8);
        }
        return this.id;
    }

    private void extractSequenceNumber() {
        if (this.sequenceNumber == -1) {
            short seqNum = this.payload.getUnsignedByte(10);
            if (seqNum >= 0) {
                this.sequenceNumber = seqNum;
            } else {
                throw new IllegalStateException("Could not extract sequence number");
            }
        }
    }

    private void extractSequenceCount() {
        if (this.sequenceCount == -1) {
            short seqCnt = this.payload.getUnsignedByte(11);
            if (seqCnt >= 0) {
                this.sequenceCount = seqCnt;
            } else {
                throw new IllegalStateException("Could not extract sequence count");
            }
        }
    }

    private void extractData() {
        int length = this.payload.readableBytes() - 12;
        byte[] buf = new byte[length];
        this.payload.getBytes(12, buf, 0, length);
        this.data = buf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID: ");
        sb.append(this.id);
        sb.append("\tSequence: ");
        sb.append(this.sequenceNumber + 1);
        sb.append("/");
        sb.append(this.sequenceCount);
        sb.append("\tArrival: ");
        sb.append(this.arrival);
        sb.append("\tData size: ");
        sb.append(this.payload.readableBytes());
        return sb.toString();
    }
}

