/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.converters.AbstractDateConverter;
import org.graylog2.plugin.inputs.Converter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.YearMonth;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter
extends AbstractDateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DateConverter.class);
    private final String dateFormat;

    public DateConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.DATE, config);
        if (config.get("date_format") == null || ((String)config.get("date_format")).isEmpty()) {
            throw new ConfigurationException("Missing config [date_format].");
        }
        this.dateFormat = ((String)config.get("date_format")).trim();
    }

    @Override
    @Nullable
    public Object convert(@Nullable String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        LOG.debug("Trying to parse date <{}> with pattern <{}> and timezone <{}>.", new Object[]{value, this.dateFormat, this.timeZone});
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.dateFormat).withDefaultYear(YearMonth.now((DateTimeZone)this.timeZone).getYear()).withZone(this.timeZone);
        return DateTime.parse((String)value, (DateTimeFormatter)formatter);
    }
}

