/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.ldap;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.net.ssl.TrustManager;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.models.system.ldap.requests.LdapSettingsRequest;
import org.graylog2.rest.models.system.ldap.requests.LdapTestConfigRequest;
import org.graylog2.rest.models.system.ldap.responses.LdapSettingsResponse;
import org.graylog2.rest.models.system.ldap.responses.LdapTestConfigResponse;
import org.graylog2.security.TrustAllX509TrustManager;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsImpl;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ldap.LdapEntry;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/LDAP", description="LDAP settings")
@Path(value="/system/ldap")
public class LdapResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LdapResource.class);
    @Inject
    private LdapSettingsService ldapSettingsService;
    @Inject
    private LdapSettingsImpl.Factory ldapSettingsFactory;
    @Inject
    private LdapConnector ldapConnector;

    @GET
    @Timed
    @RequiresPermissions(value={"ldap:edit"})
    @ApiOperation(value="Get the LDAP configuration if it is configured")
    @Path(value="/settings")
    @Produces(value={"application/json"})
    public LdapSettingsResponse getLdapSettings() {
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        if (ldapSettings == null) {
            return LdapSettingsResponse.emptyDisabled();
        }
        return LdapSettingsResponse.create(ldapSettings.isEnabled(), ldapSettings.getSystemUserName(), ldapSettings.getSystemPassword(), ldapSettings.getUri(), ldapSettings.isUseStartTls(), ldapSettings.isTrustAllCertificates(), ldapSettings.isActiveDirectory(), ldapSettings.getSearchBase(), ldapSettings.getSearchPattern(), ldapSettings.getDisplayNameAttribute(), ldapSettings.getDefaultGroup(), ldapSettings.getGroupMapping(), ldapSettings.getGroupSearchBase(), ldapSettings.getGroupIdAttribute(), ldapSettings.getAdditionalDefaultGroups(), ldapSettings.getGroupSearchPattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Timed
    @RequiresPermissions(value={"ldap:edit"})
    @ApiOperation(value="Test LDAP Configuration")
    @Path(value="/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public LdapTestConfigResponse testLdapConfiguration(@ApiParam(name="Configuration to test", required=true) @Valid @NotNull LdapTestConfigRequest request) {
        LdapConnectionConfig config = new LdapConnectionConfig();
        URI ldapUri = request.ldapUri();
        config.setLdapHost(ldapUri.getHost());
        config.setLdapPort(ldapUri.getPort());
        config.setUseSsl(ldapUri.getScheme().startsWith("ldaps"));
        config.setUseTls(request.useStartTls());
        if (request.trustAllCertificates()) {
            config.setTrustManagers(new TrustManager[]{new TrustAllX509TrustManager()});
        }
        if (!Strings.isNullOrEmpty((String)request.systemUsername()) && !Strings.isNullOrEmpty((String)request.systemPassword())) {
            config.setName(request.systemUsername());
            config.setCredentials(request.systemPassword());
        }
        LdapNetworkConnection connection = null;
        try {
            try {
                connection = this.ldapConnector.connect(config);
            }
            catch (LdapException e) {
                LdapTestConfigResponse ldapTestConfigResponse = LdapTestConfigResponse.create(false, false, false, Collections.emptyMap(), Collections.emptySet(), e.getMessage());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException e2) {
                        LOG.warn("Unable to close LDAP connection.", (Throwable)e2);
                    }
                }
                return ldapTestConfigResponse;
            }
            if (null == connection) {
                LdapTestConfigResponse e = LdapTestConfigResponse.create(false, false, false, Collections.emptyMap(), Collections.emptySet(), "Could not connect to LDAP server");
                return e;
            }
            boolean connected = connection.isConnected();
            boolean systemAuthenticated = connection.isAuthenticated();
            if (request.testConnectOnly()) {
                LdapTestConfigResponse e2 = LdapTestConfigResponse.create(connected, systemAuthenticated, false, Collections.emptyMap(), Collections.emptySet());
                return e2;
            }
            String userPrincipalName = null;
            boolean loginAuthenticated = false;
            Map<String, String> entryMap = Collections.emptyMap();
            String exception = null;
            Set<String> groups = Collections.emptySet();
            try {
                LdapEntry entry = this.ldapConnector.search(connection, request.searchBase(), request.searchPattern(), "*", request.principal(), request.activeDirectory(), request.groupSearchBase(), request.groupIdAttribute(), request.groupSearchPattern());
                if (entry != null) {
                    userPrincipalName = entry.getBindPrincipal();
                    entryMap = entry.getAttributes();
                    groups = entry.getGroups();
                }
            }
            catch (CursorException | LdapException e) {
                exception = e.getMessage();
            }
            try {
                loginAuthenticated = this.ldapConnector.authenticate(connection, userPrincipalName, request.password());
            }
            catch (Exception e) {
                exception = e.getMessage();
            }
            LdapTestConfigResponse ldapTestConfigResponse = LdapTestConfigResponse.create(connected, systemAuthenticated, loginAuthenticated, entryMap, groups, exception);
            return ldapTestConfigResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close LDAP connection.", (Throwable)e);
                }
            }
        }
    }

    @PUT
    @Timed
    @RequiresPermissions(value={"ldap:edit"})
    @ApiOperation(value="Update the LDAP configuration")
    @Path(value="/settings")
    @Consumes(value={"application/json"})
    @AuditLog(object="LDAP configuration")
    public void updateLdapSettings(@ApiParam(name="JSON body", required=true) @Valid @NotNull LdapSettingsRequest request) throws ValidationException {
        LdapSettings ldapSettings = (LdapSettings)MoreObjects.firstNonNull((Object)this.ldapSettingsService.load(), (Object)this.ldapSettingsFactory.createEmpty());
        ldapSettings.setSystemUsername(request.systemUsername());
        ldapSettings.setSystemPassword(request.systemPassword());
        ldapSettings.setUri(request.ldapUri());
        ldapSettings.setUseStartTls(request.useStartTls());
        ldapSettings.setTrustAllCertificates(request.trustAllCertificates());
        ldapSettings.setActiveDirectory(request.activeDirectory());
        ldapSettings.setSearchPattern(request.searchPattern());
        ldapSettings.setSearchBase(request.searchBase());
        ldapSettings.setEnabled(request.enabled());
        ldapSettings.setDisplayNameAttribute(request.displayNameAttribute());
        ldapSettings.setDefaultGroup(request.defaultGroup());
        ldapSettings.setGroupMapping(request.groupMapping());
        ldapSettings.setGroupSearchBase(request.groupSearchBase());
        ldapSettings.setGroupIdAttribute(request.groupIdAttribute());
        ldapSettings.setGroupSearchPattern(request.groupSearchPattern());
        ldapSettings.setAdditionalDefaultGroups(request.additionalDefaultGroups());
        this.ldapSettingsService.save(ldapSettings);
    }

    @DELETE
    @Timed
    @RequiresPermissions(value={"ldap:edit"})
    @ApiOperation(value="Remove the LDAP configuration")
    @Path(value="/settings")
    @AuditLog(object="LDAP configuration")
    public void deleteLdapSettings() {
        this.ldapSettingsService.delete();
    }

    @GET
    @ApiOperation(value="Get the LDAP group to Graylog role mapping", notes="The return value is a simple hash with keys being the LDAP group names and the values the corresponding Graylog role names.")
    @RequiresPermissions(value={"ldapgroups:read", "ldap:edit"}, logical=Logical.OR)
    @Path(value="/settings/groups")
    @Produces(value={"application/json"})
    public Map<String, String> readGroupMapping() {
        LdapSettings ldapSettings = (LdapSettings)MoreObjects.firstNonNull((Object)this.ldapSettingsService.load(), (Object)this.ldapSettingsFactory.createEmpty());
        return ldapSettings.getGroupMapping();
    }

    @PUT
    @RequiresPermissions(value={"ldapgroups:edit", "ldap:edit"}, logical=Logical.OR)
    @ApiOperation(value="Update the LDAP group to Graylog role mapping", notes="Corresponds directly to the output of GET /system/ldap/settings/groups")
    @Path(value="/settings/groups")
    @Consumes(value={"application/json"})
    @AuditLog(object="LDAP group mapping", captureRequestEntity=true, captureResponseEntity=true)
    public Response updateGroupMappingSettings(@ApiParam(name="JSON body", required=true, value="A hash in which the keys are the LDAP group names and values is the Graylog role name.") @NotNull Map<String, String> groupMapping) throws ValidationException {
        LdapSettings ldapSettings = (LdapSettings)MoreObjects.firstNonNull((Object)this.ldapSettingsService.load(), (Object)this.ldapSettingsFactory.createEmpty());
        ldapSettings.setGroupMapping(groupMapping);
        this.ldapSettingsService.save(ldapSettings);
        return Response.noContent().build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @ApiOperation(value="Get the available LDAP groups", notes="")
    @RequiresPermissions(value={"ldapgroups:read"})
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public Set<String> readGroups() {
        LdapSettings ldapSettings = (LdapSettings)MoreObjects.firstNonNull((Object)this.ldapSettingsService.load(), (Object)this.ldapSettingsFactory.createEmpty());
        if (!ldapSettings.isEnabled()) {
            throw new BadRequestException("LDAP is disabled.");
        }
        if (Strings.isNullOrEmpty((String)ldapSettings.getGroupSearchBase())) throw new BadRequestException("LDAP group configuration settings are not set.");
        if (Strings.isNullOrEmpty((String)ldapSettings.getGroupIdAttribute())) {
            throw new BadRequestException("LDAP group configuration settings are not set.");
        }
        LdapConnectionConfig config = new LdapConnectionConfig();
        URI ldapUri = ldapSettings.getUri();
        config.setLdapHost(ldapUri.getHost());
        config.setLdapPort(ldapUri.getPort());
        config.setUseSsl(ldapUri.getScheme().startsWith("ldaps"));
        config.setUseTls(ldapSettings.isUseStartTls());
        if (ldapSettings.isTrustAllCertificates()) {
            config.setTrustManagers(new TrustManager[]{new TrustAllX509TrustManager()});
        }
        if (!Strings.isNullOrEmpty((String)ldapSettings.getSystemUserName()) && !Strings.isNullOrEmpty((String)ldapSettings.getSystemPassword())) {
            config.setName(ldapSettings.getSystemUserName());
            config.setCredentials(ldapSettings.getSystemPassword());
        }
        try (LdapNetworkConnection connection = this.ldapConnector.connect(config);){
            Set<String> set = this.ldapConnector.listGroups(connection, ldapSettings.getGroupSearchBase(), ldapSettings.getGroupSearchPattern(), ldapSettings.getGroupIdAttribute());
            return set;
        }
        catch (IOException | LdapException e) {
            LOG.error("Unable to retrieve available LDAP groups", e);
            throw new InternalServerErrorException("Unable to retrieve available LDAP groups", e);
        }
    }
}

